"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenuWithRouterSupport = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _context_menu_item_nav_by_router = require("./context_menu_item_nav_by_router");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A context menu that allows for items in the menu to route to other Kibana destinations using the Router
 * (thus avoiding full page refreshes).
 * Menu also supports automatically closing the popup when an item is clicked.
 */
const ContextMenuWithRouterSupport = /*#__PURE__*/(0, _react.memo)(({
  items,
  button,
  panelPaddingSize,
  anchorPosition,
  maxWidth = '32ch',
  maxHeight = '255px',
  fixedWidth = false,
  title,
  loading = false,
  hoverInfo,
  isNavigationDisabled = false,
  ...commonProps
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(commonProps['data-test-subj']);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const handleCloseMenu = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const handleToggleMenu = (0, _react.useCallback)(() => setIsOpen(!isOpen), [isOpen]);
  const panelProps = (0, _react.useMemo)(() => {
    return {
      'data-test-subj': getTestId('popoverPanel')
    };
  }, [getTestId]);
  const menuItems = (0, _react.useMemo)(() => {
    return items.map((itemProps, index) => {
      var _itemProps$dataTest2;
      if (loading) {
        var _itemProps$dataTest;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
          lines: 1,
          key: (0, _uuid.v4)(),
          "data-test-subj": (_itemProps$dataTest = itemProps['data-test-subj']) !== null && _itemProps$dataTest !== void 0 ? _itemProps$dataTest : getTestId(`item-loading-${index}`)
        });
      }
      return /*#__PURE__*/_react.default.createElement(_context_menu_item_nav_by_router.ContextMenuItemNavByRouter, (0, _extends2.default)({}, itemProps, {
        isNavigationDisabled: isNavigationDisabled,
        key: (0, _uuid.v4)(),
        "data-test-subj": (_itemProps$dataTest2 = itemProps['data-test-subj']) !== null && _itemProps$dataTest2 !== void 0 ? _itemProps$dataTest2 : getTestId(`item-${index}`),
        textTruncate: Boolean(maxWidth) || itemProps.textTruncate,
        hoverInfo: hoverInfo,
        onClick: ev => {
          handleCloseMenu();
          if (itemProps.onClick) {
            return itemProps.onClick(ev);
          }
        }
      }));
    });
  }, [items, loading, isNavigationDisabled, getTestId, maxWidth, hoverInfo, handleCloseMenu]);
  const additionalContextMenuPanelProps = (0, _react.useMemo)(() => {
    const newAdditionalProps = {
      className: 'eui-yScroll',
      style: {}
    };
    if (maxWidth && !fixedWidth) {
      newAdditionalProps.style.maxWidth = maxWidth;
    }
    if (maxHeight) {
      newAdditionalProps.style.maxHeight = maxHeight;
    }
    if (fixedWidth) {
      newAdditionalProps.style.width = maxWidth !== null && maxWidth !== void 0 ? maxWidth : '32ch';
    }
    return newAdditionalProps;
  }, [maxWidth, fixedWidth, maxHeight]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({}, commonProps, {
    anchorPosition: anchorPosition,
    panelPaddingSize: panelPaddingSize,
    panelProps: panelProps,
    button:
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events
    _react.default.createElement("div", {
      className: "eui-displayInlineBlock",
      "data-test-subj": getTestId('triggerButtonWrapper'),
      onClick: handleToggleMenu
    }, button),
    isOpen: isOpen,
    closePopover: handleCloseMenu
  }), title ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "m"
  }, title) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, (0, _extends2.default)({}, additionalContextMenuPanelProps, {
    items: menuItems
  })));
});
exports.ContextMenuWithRouterSupport = ContextMenuWithRouterSupport;
ContextMenuWithRouterSupport.displayName = 'ContextMenuWithRouterSupport';