"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidePanelContentManager = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _command_list = require("../command_list");
var _use_with_command_list = require("../../hooks/state_selectors/use_with_command_list");
var _side_panel_content_layout = require("./side_panel_content_layout");
var _use_with_side_panel = require("../../hooks/state_selectors/use_with_side_panel");
var _use_console_state_dispatch = require("../../hooks/state_selectors/use_console_state_dispatch");
var _use_data_test_subj = require("../../hooks/state_selectors/use_data_test_subj");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding-top: ${({
  theme: {
    eui
  }
}) => eui.euiPanelPaddingModifiers.paddingSmall};
  padding-right: ${({
  theme: {
    eui
  }
}) => eui.euiPanelPaddingModifiers.paddingSmall};
`;
const SidePanelContentManager = /*#__PURE__*/(0, _react.memo)(() => {
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const commands = (0, _use_with_command_list.useWithCommandList)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)('sidePanel'));
  const show = (0, _use_with_side_panel.useWithSidePanel)().show;
  const closeHelpPanel = (0, _react.useCallback)(() => {
    dispatch({
      type: 'showSidePanel',
      payload: {
        show: null
      }
    });
  }, [dispatch]);
  const panelHeader = (0, _react.useMemo)(() => {
    if (show === 'help') {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        "data-test-subj": getTestId('headerTitle')
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.sidePanel.helpTitle",
        defaultMessage: "Help"
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": "closeSidePanelIcon",
        iconType: "cross",
        color: "text",
        onClick: closeHelpPanel,
        "data-test-subj": getTestId('headerCloseButton')
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.console.sidePanel.helpDescription",
        defaultMessage: "Use the add ({icon}) button to populate a response action to the text bar. Add additional parameters or comments as necessary.",
        values: {
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "plusInCircle"
          })
        }
      })));
    }
    return null;
  }, [show, getTestId, closeHelpPanel]);
  const panelBody = (0, _react.useMemo)(() => {
    if (show === 'help') {
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": getTestId('helpContent')
      }, /*#__PURE__*/_react.default.createElement(_command_list.CommandList, {
        commands: commands,
        display: "table"
      }));
    }
    return null;
  }, [commands, getTestId, show]);
  if (!show) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_side_panel_content_layout.SidePanelContentLayout, {
    headerContent: panelHeader
  }, panelBody);
});
exports.SidePanelContentManager = SidePanelContentManager;
SidePanelContentManager.displayName = 'RightPanelContentManager';