"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputAreaPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _command_input_history = require("./command_input_history");
var _use_console_state_dispatch = require("../../../hooks/state_selectors/use_console_state_dispatch");
var _use_with_input_show_popover = require("../../../hooks/state_selectors/use_with_input_show_popover");
var _use_data_test_subj = require("../../../hooks/state_selectors/use_data_test_subj");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InputAreaPopover = /*#__PURE__*/(0, _react.memo)(({
  children,
  width = '92vw'
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const show = (0, _use_with_input_show_popover.useWithInputShowPopover)();
  const isPopoverOpen = show !== undefined;
  const dispatch = (0, _use_console_state_dispatch.useConsoleStateDispatch)();
  const popoverPanelStyles = (0, _react.useMemo)(() => {
    return {
      width,
      borderBottomLeftRadius: 0,
      borderBottomRightRadius: 0
    };
  }, [width]);
  const focusTrapProps = (0, _react.useMemo)(() => {
    return {
      clickOutsideDisables: true
    };
  }, []);
  const handlePopoverOnClose = (0, _react.useCallback)(() => {
    dispatch({
      type: 'updateInputPopoverState',
      payload: {
        show: undefined
      }
    });
    dispatch({
      type: 'addFocusToKeyCapture'
    });
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    // Anytime the popover is closed, focus on Input area
    if (!show) {
      dispatch({
        type: 'addFocusToKeyCapture'
      });
    }
  }, [dispatch, show]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: children,
    closePopover: handlePopoverOnClose,
    isOpen: isPopoverOpen,
    panelStyle: popoverPanelStyles,
    anchorPosition: "upLeft",
    hasArrow: false,
    display: "block",
    attachToAnchor: true,
    focusTrapProps: focusTrapProps,
    ownFocus: false,
    "data-test-subj": getTestId('inputPopover')
  }, show && /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    clickOutsideDisables: true
  }, show === 'input-history' && /*#__PURE__*/_react.default.createElement(_command_input_history.CommandInputHistory, null)));
});
exports.InputAreaPopover = InputAreaPopover;
InputAreaPopover.displayName = 'InputAreaPopover';