"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHOW_COMMENTS_LABEL = exports.POLICY_EFFECT_SCOPE_TITLE = exports.POLICY_EFFECT_SCOPE = exports.OS_WINDOWS = exports.OS_MAC = exports.OS_LINUX = exports.LAST_UPDATED_BY = exports.LAST_UPDATED = exports.HIDE_COMMENTS_LABEL = exports.GLOBAL_EFFECT_SCOPE = exports.EXPAND_ACTION = exports.DESCRIPTION_LABEL = exports.CREATED_BY = exports.CREATED = exports.CONDITION_OS = exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = exports.CONDITION_OPERATOR_TYPE_NESTED = exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = exports.CONDITION_OPERATOR_TYPE_MATCH = exports.CONDITION_OPERATOR_TYPE_LIST = exports.CONDITION_OPERATOR_TYPE_EXISTS = exports.CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH = exports.CONDITION_AND = exports.COLLAPSE_ACTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LAST_UPDATED = _i18n.i18n.translate('xpack.securitySolution.artifactCard.lastUpdated', {
  defaultMessage: 'Last updated'
});
exports.LAST_UPDATED = LAST_UPDATED;
const CREATED = _i18n.i18n.translate('xpack.securitySolution.artifactCard.created', {
  defaultMessage: 'Created'
});
exports.CREATED = CREATED;
const LAST_UPDATED_BY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.lastUpdatedBy', {
  defaultMessage: 'Updated by'
});
exports.LAST_UPDATED_BY = LAST_UPDATED_BY;
const CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.createdBy', {
  defaultMessage: 'Created by'
});
exports.CREATED_BY = CREATED_BY;
const GLOBAL_EFFECT_SCOPE = _i18n.i18n.translate('xpack.securitySolution.artifactCard.globalEffectScope', {
  defaultMessage: 'Applied globally'
});
exports.GLOBAL_EFFECT_SCOPE = GLOBAL_EFFECT_SCOPE;
const POLICY_EFFECT_SCOPE = (policyCount = 0) => {
  return _i18n.i18n.translate('xpack.securitySolution.artifactCard.policyEffectScope', {
    defaultMessage: 'Applied to {count} {count, plural, one {policy} other {policies}}',
    values: {
      count: policyCount
    }
  });
};
exports.POLICY_EFFECT_SCOPE = POLICY_EFFECT_SCOPE;
const POLICY_EFFECT_SCOPE_TITLE = (policyCount = 0) => _i18n.i18n.translate('xpack.securitySolution.artifactCard.policyEffectScope.title', {
  defaultMessage: 'Applied to the following {count, plural, one {policy} other {policies}}',
  values: {
    count: policyCount
  }
});
exports.POLICY_EFFECT_SCOPE_TITLE = POLICY_EFFECT_SCOPE_TITLE;
const CONDITION_OPERATOR_TYPE_MATCH = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchOperator', {
  defaultMessage: 'IS'
});
exports.CONDITION_OPERATOR_TYPE_MATCH = CONDITION_OPERATOR_TYPE_MATCH;
const CONDITION_OPERATOR_TYPE_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchOperator.not', {
  defaultMessage: 'IS NOT'
});
exports.CONDITION_OPERATOR_TYPE_NOT_MATCH = CONDITION_OPERATOR_TYPE_NOT_MATCH;
const CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.wildcardMatchesOperator', {
  defaultMessage: 'MATCHES'
});
exports.CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES = CONDITION_OPERATOR_TYPE_WILDCARD_MATCHES;
const CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.wildcardDoesNotMatchOperator', {
  defaultMessage: 'DOES NOT MATCH'
});
exports.CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH = CONDITION_OPERATOR_TYPE_DOES_NOT_MATCH;
const CONDITION_OPERATOR_TYPE_NESTED = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.nestedOperator', {
  defaultMessage: 'has'
});
exports.CONDITION_OPERATOR_TYPE_NESTED = CONDITION_OPERATOR_TYPE_NESTED;
const CONDITION_OPERATOR_TYPE_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchAnyOperator', {
  defaultMessage: 'is one of'
});
exports.CONDITION_OPERATOR_TYPE_MATCH_ANY = CONDITION_OPERATOR_TYPE_MATCH_ANY;
const CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.matchAnyOperator.not', {
  defaultMessage: 'is not one of'
});
exports.CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY = CONDITION_OPERATOR_TYPE_NOT_MATCH_ANY;
const CONDITION_OPERATOR_TYPE_EXISTS = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.existsOperator', {
  defaultMessage: 'exists'
});
exports.CONDITION_OPERATOR_TYPE_EXISTS = CONDITION_OPERATOR_TYPE_EXISTS;
const CONDITION_OPERATOR_TYPE_LIST = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.listOperator', {
  defaultMessage: 'included in'
});
exports.CONDITION_OPERATOR_TYPE_LIST = CONDITION_OPERATOR_TYPE_LIST;
const CONDITION_OS = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.os', {
  defaultMessage: 'OS'
});
exports.CONDITION_OS = CONDITION_OS;
const CONDITION_AND = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.and', {
  defaultMessage: 'AND'
});
exports.CONDITION_AND = CONDITION_AND;
const OS_WINDOWS = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.windows', {
  defaultMessage: 'Windows'
});
exports.OS_WINDOWS = OS_WINDOWS;
const OS_LINUX = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.linux', {
  defaultMessage: 'Linux'
});
exports.OS_LINUX = OS_LINUX;
const OS_MAC = _i18n.i18n.translate('xpack.securitySolution.artifactCard.conditions.macos', {
  defaultMessage: 'Mac'
});
exports.OS_MAC = OS_MAC;
const EXPAND_ACTION = _i18n.i18n.translate('xpack.securitySolution.artifactExpandableCard.expand', {
  defaultMessage: 'Expand'
});
exports.EXPAND_ACTION = EXPAND_ACTION;
const COLLAPSE_ACTION = _i18n.i18n.translate('xpack.securitySolution.artifactExpandableCard.collpase', {
  defaultMessage: 'Collapse'
});
exports.COLLAPSE_ACTION = COLLAPSE_ACTION;
const SHOW_COMMENTS_LABEL = (count = 0) => _i18n.i18n.translate('xpack.securitySolution.artifactCard.comments.label.show', {
  defaultMessage: 'Show comments ({count})',
  values: {
    count
  }
});
exports.SHOW_COMMENTS_LABEL = SHOW_COMMENTS_LABEL;
const HIDE_COMMENTS_LABEL = (count = 0) => _i18n.i18n.translate('xpack.securitySolution.artifactCard.comments.label.hide', {
  defaultMessage: 'Hide comments ({count})',
  values: {
    count
  }
});
exports.HIDE_COMMENTS_LABEL = HIDE_COMMENTS_LABEL;
const DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.artifactMinifiedCard.descriptionLabel', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_LABEL = DESCRIPTION_LABEL;