"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _artifact_entry_card = require("../../artifact_entry_card");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GridHeaderContainer = (0, _styledComponents.default)(_artifact_entry_card.CardSectionPanel)`
  padding-top: 0;
  padding-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const GridHeader = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj,
  expandAllIconType,
  onExpandCollapseAll
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const expandToggleElement = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": getTestId('expandCollapseAllButton'),
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.artifactCardGrid.expandCollapseLabel', {
      defaultMessage: '{action} all cards',
      values: {
        action: 'unfold' ? 'Expand' : 'Collapse'
      }
    }),
    iconType: expandAllIconType,
    onClick: () => onExpandCollapseAll(),
    style: {
      marginLeft: '-5px'
    }
  }), [getTestId, expandAllIconType, onExpandCollapseAll]);
  return /*#__PURE__*/_react.default.createElement(GridHeaderContainer, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_artifact_entry_card.CardCompressedHeaderLayout, {
    expanded: false,
    expandToggle: expandToggleElement,
    "data-test-subj": getTestId('layout'),
    flushTop: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": getTestId('name')
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.artifactCardGrid.nameColumn",
      defaultMessage: "Name"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": getTestId('description')
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.artifactCardGrid.DescriptionColumn",
      defaultMessage: "Description"
    }))),
    effectScope: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": getTestId('assignment')
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.artifactCardGrid.assignmentColumn",
      defaultMessage: "Assignment"
    }))),
    actionMenu: true
  }));
});
exports.GridHeader = GridHeader;
GridHeader.displayName = 'GridHeader';