"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdministrationListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdministrationListPage = /*#__PURE__*/(0, _react.memo)(({
  title,
  subtitle,
  actions,
  children,
  restrictWidth = false,
  hasBottomBorder = true,
  hideHeader = false,
  headerBackComponent,
  ...otherProps
}) => {
  const header = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      alignItems: "flexStart"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, headerBackComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, headerBackComponent)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "header-page-title"
    }, title))));
  }, [headerBackComponent, title]);
  const description = (0, _react.useMemo)(() => {
    return subtitle ? /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "header-panel-subtitle"
    }, subtitle) : undefined;
  }, [subtitle]);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(otherProps['data-test-subj']);
  return /*#__PURE__*/_react.default.createElement("div", otherProps, !hideHeader && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: header,
    description: description,
    bottomBorder: hasBottomBorder,
    rightSideItems: actions ? [actions] : undefined,
    restrictWidth: restrictWidth,
    "data-test-subj": getTestId('header')
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    color: "transparent",
    restrictWidth: restrictWidth
  }, children));
});
exports.AdministrationListPage = AdministrationListPage;
AdministrationListPage.displayName = 'AdministrationListPage';