"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnOpenCloseHandler = exports.useHasSecurityCapability = void 0;
var _react = require("react");
var _kibana = require("./common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOnOpenCloseHandler = () => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const handleOnClose = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, []);
  const handleOnOpen = (0, _react.useCallback)(() => {
    setIsOpen(true);
  }, []);
  return [isOpen, handleOnOpen, handleOnClose];
};

/**
 *
 * @param capability Main Security feature capability name.
 */
exports.useOnOpenCloseHandler = useOnOpenCloseHandler;
const useHasSecurityCapability = capability => {
  const {
    capabilities
  } = (0, _kibana.useKibana)().services.application;
  return !!capabilities.siem[capability];
};
exports.useHasSecurityCapability = useHasSecurityCapability;