"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanelKey = exports.UserPanel = exports.USER_PANEL_RISK_SCORE_QUERY_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _use_managed_user = require("../../../timelines/components/side_panel/new_user_detail/hooks/use_managed_user");
var _use_observed_user = require("../../../timelines/components/side_panel/new_user_detail/hooks/use_observed_user");
var _manage_query = require("../../../common/components/page/manage_query");
var _model = require("../../../explore/users/store/model");
var _get_criteria_from_users_type = require("../../../common/components/ml/criteria/get_criteria_from_users_type");
var _use_global_time = require("../../../common/containers/use_global_time");
var _anomaly_table_provider = require("../../../common/components/ml/anomaly/anomaly_table_provider");
var _search_strategy = require("../../../../common/search_strategy");
var _risk_score = require("../../../explore/containers/risk_score");
var _risk_engine = require("../../../../common/risk_engine");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _risk_inputs_left = require("../risk_inputs_left");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _content = require("./content");
var _header = require("./header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserPanelKey = 'user-panel';
exports.UserPanelKey = UserPanelKey;
const USER_PANEL_RISK_SCORE_QUERY_ID = 'userPanelRiskScoreQuery';
exports.USER_PANEL_RISK_SCORE_QUERY_ID = USER_PANEL_RISK_SCORE_QUERY_ID;
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const UserPanel = ({
  contextID,
  scopeId,
  userName,
  isDraggable
}) => {
  const userNameFilterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const riskScoreState = (0, _risk_score.useRiskScore)({
    riskEntity: _risk_engine.RiskScoreEntity.user,
    filterQuery: userNameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION
  });
  const {
    inspect,
    refetch,
    loading
  } = riskScoreState;
  const {
    to,
    from,
    isInitializing,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const observedUser = (0, _use_observed_user.useObservedUser)(userName);
  const managedUser = (0, _use_managed_user.useManagedUser)(userName, observedUser);
  const {
    data: userRisk
  } = riskScoreState;
  const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    loading,
    queryId: USER_PANEL_RISK_SCORE_QUERY_ID,
    refetch,
    setQuery
  });
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const openPanel = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _risk_inputs_left.RiskInputsPanelKey,
      params: {
        riskInputs: userRiskData === null || userRiskData === void 0 ? void 0 : userRiskData.user.risk.inputs
      }
    });
  }, [openLeftPanel, userRiskData === null || userRiskData === void 0 ? void 0 : userRiskData.user.risk.inputs]);
  if (riskScoreState.loading || observedUser.isLoading || managedUser.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, null);
  }
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _get_criteria_from_users_type.getCriteriaFromUsersType)(_model.UsersType.details, userName),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => {
    const observedUserWithAnomalies = {
      ...observedUser,
      anomalies: {
        isLoading: isLoadingAnomaliesData,
        anomalies: anomaliesData,
        jobNameById
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
      flyoutIsExpandable: !!(userRiskData !== null && userRiskData !== void 0 && userRiskData.user.risk),
      expandDetails: openPanel
    }), /*#__PURE__*/_react.default.createElement(_header.UserPanelHeader, {
      userName: userName,
      observedUser: observedUserWithAnomalies,
      managedUser: managedUser
    }), /*#__PURE__*/_react.default.createElement(_content.UserPanelContent, {
      managedUser: managedUser,
      observedUser: observedUserWithAnomalies,
      riskScoreState: riskScoreState,
      contextID: contextID,
      scopeId: scopeId,
      isDraggable: !!isDraggable
    }));
  });
};
exports.UserPanel = UserPanel;
UserPanel.displayName = 'UserPanel';