"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18n = require("@kbn/i18n");
var _inspect = require("../../../../common/components/inspect");
var _constants = require("../../../../timelines/components/side_panel/new_user_detail/constants");
var _formatted_date = require("../../../../common/components/formatted_date");
var _risk_engine = require("../../../../../common/risk_engine");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _risk_score_summary = require("../../../../common/components/visualization_actions/lens_attributes/common/risk_scores/risk_score_summary");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _risk_inputs_left = require("../../risk_inputs_left");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_VISUALIZATION_HEIGHT = 126; //  Static height in pixels specified by design
const LAST_30_DAYS = {
  from: 'now-30d',
  to: 'now'
};
const RiskSummary = /*#__PURE__*/_react.default.memo(({
  riskScoreData,
  queryId
}) => {
  var _userRiskData$user$ri4;
  const {
    data: userRisk
  } = riskScoreData;
  const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const openPanel = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _risk_inputs_left.RiskInputsPanelKey,
      params: {
        riskInputs: userRiskData === null || userRiskData === void 0 ? void 0 : userRiskData.user.risk.inputs
      }
    });
  }, [openLeftPanel, userRiskData === null || userRiskData === void 0 ? void 0 : userRiskData.user.risk.inputs]);
  const lensAttributes = (0, _react.useMemo)(() => {
    var _userRiskData$user, _userRiskData$user$ri, _userRiskData$user2;
    return (0, _risk_score_summary.getRiskScoreSummaryAttributes)({
      severity: userRiskData === null || userRiskData === void 0 ? void 0 : (_userRiskData$user = userRiskData.user) === null || _userRiskData$user === void 0 ? void 0 : (_userRiskData$user$ri = _userRiskData$user.risk) === null || _userRiskData$user$ri === void 0 ? void 0 : _userRiskData$user$ri.calculated_level,
      query: `user.name: ${userRiskData === null || userRiskData === void 0 ? void 0 : (_userRiskData$user2 = userRiskData.user) === null || _userRiskData$user2 === void 0 ? void 0 : _userRiskData$user2.name}`,
      spaceId: 'default',
      riskEntity: _risk_engine.RiskScoreEntity.user
    });
  }, [userRiskData]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'category',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.categoryColumnLabel",
      defaultMessage: "Category"
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true
  }, {
    field: 'count',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.inputsColumnLabel",
      defaultMessage: "Inputs"
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    dataType: 'number'
  }], []);
  const xsFontSize = (0, _eui.useEuiFontSize)('xxs').fontSize;
  const items = (0, _react.useMemo)(() => {
    var _userRiskData$user$ri2, _userRiskData$user$ri3;
    return [{
      category: _i18n.i18n.translate('xpack.securitySolution.flyout.entityDetails.alertsGroupLabel', {
        defaultMessage: 'Alerts'
      }),
      count: (_userRiskData$user$ri2 = userRiskData === null || userRiskData === void 0 ? void 0 : (_userRiskData$user$ri3 = userRiskData.user.risk.inputs) === null || _userRiskData$user$ri3 === void 0 ? void 0 : _userRiskData$user$ri3.length) !== null && _userRiskData$user$ri2 !== void 0 ? _userRiskData$user$ri2 : 0
    }];
  }, [userRiskData === null || userRiskData === void 0 ? void 0 : (_userRiskData$user$ri4 = userRiskData.user.risk.inputs) === null || _userRiskData$user$ri4 === void 0 ? void 0 : _userRiskData$user$ri4.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    id: 'risk_summary',
    buttonProps: {
      css: (0, _react2.css)`
          color: ${euiTheme.colors.primary};
        `
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.title",
      defaultMessage: "Risk summary"
    }))),
    extraAction: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "risk-summary-updatedAt",
      css: (0, _react2.css)`
            font-size: ${xsFontSize};
          `
    }, userRiskData && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskUpdatedTime",
      defaultMessage: "Updated {time}",
      values: {
        time: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
          value: userRiskData['@timestamp'],
          dateFormat: "MMM D, YYYY",
          relativeThresholdInHrs: _constants.ONE_WEEK_IN_HOURS
        })
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs",
        defaultMessage: "Risk inputs"
      }),
      link: {
        callback: openPanel,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.entityDetails.showAllRiskInputs",
          defaultMessage: "Show all risk inputs"
        })
      },
      iconType: 'arrowStart'
    },
    expand: {
      expandable: false
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Improve Visualization loading state by predefining the size
    css: (0, _react2.css)`
                height: ${LENS_VISUALIZATION_HEIGHT}px;
              `
  }, userRiskData && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    lensAttributes: lensAttributes,
    id: `RiskSummary-risk_score_metric`,
    timerange: LAST_30_DAYS,
    width: '100%',
    height: LENS_VISUALIZATION_HEIGHT,
    disableOnClickFilter: true,
    inspectTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.inspectVisualizationTitle",
      defaultMessage: "Risk Summary Visualization"
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement("div", {
    // Anchors the position absolute inspect button (nearest positioned ancestor)
    css: (0, _react2.css)`
                  position: relative;
                `
  }, /*#__PURE__*/_react.default.createElement("div", {
    // Position the inspect button above the table
    css: (0, _react2.css)`
                    position: absolute;
                    right: 0;
                    top: -${_uiTheme.euiThemeVars.euiSize};
                  `
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: queryId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.inspectTableTitle",
      defaultMessage: "Risk Summary Table"
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "risk-summary-table",
    responsive: false,
    columns: columns,
    items: items,
    compressed: true
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }));
});
exports.RiskSummary = RiskSummary;
RiskSummary.displayName = 'RiskSummary';