"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigationGuide = void 0;
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _use_rule_with_fallback = require("../../../../detection_engine/rule_management/logic/use_rule_with_fallback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the investigation guide data for a given rule is available to render
 */
const useInvestigationGuide = ({
  dataFormattedForFieldBrowser
}) => {
  const basicAlertData = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    loading,
    error,
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(basicAlertData.ruleId);
  return {
    loading,
    error,
    basicAlertData,
    ruleNote: maybeRule === null || maybeRule === void 0 ? void 0 : maybeRule.note
  };
};
exports.useInvestigationGuide = useInvestigationGuide;