"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAccordionState = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOSED = 'closed';
const OPEN = 'open';
const toggleReducer = state => {
  return state === CLOSED ? OPEN : CLOSED;
};
/**
 * Tiny hook for controlled AccordionState
 * @param expandedInitially - is accordion expanded on first render
 */
const useAccordionState = expandedInitially => {
  const initialState = expandedInitially ? OPEN : CLOSED;
  const [state, toggle] = (0, _react.useReducer)(toggleReducer, initialState);
  const renderContent = state === OPEN;
  return {
    renderContent,
    state,
    toggle
  };
};
exports.useAccordionState = useAccordionState;