"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _i18nReact = require("@kbn/i18n-react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _empty_value = require("../../../../common/components/empty_value");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _status_popover_button = require("../../../../common/components/event_details/overview/status_popover_button");
var _context = require("../context");
var _helpers = require("../../../../common/components/event_details/helpers");
var _cell_actions = require("./cell_actions");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks if the field info has data to convert EnrichedFieldInfo into EnrichedFieldInfoWithValues
 */
function hasData(fieldInfo) {
  return !!fieldInfo && Array.isArray(fieldInfo.values);
}

/**
 * Document details status displayed in flyout right section header
 */
const DocumentStatus = () => {
  const {
    closeFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    browserFields,
    dataFormattedForFieldBrowser,
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const statusData = (0, _react.useMemo)(() => {
    const item = (0, _fp.find)({
      field: _constants.SIGNAL_STATUS_FIELD_NAME,
      category: 'kibana'
    }, dataFormattedForFieldBrowser);
    return item && (0, _helpers.getEnrichedFieldInfo)({
      eventId,
      contextId: scopeId,
      scopeId,
      browserFields,
      item
    });
  }, [browserFields, dataFormattedForFieldBrowser, eventId, scopeId]);
  if (!statusData || !hasData(statusData)) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": _test_ids.STATUS_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.statusTitle",
    defaultMessage: "Status"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !statusData || !hasData(statusData) || isPreview ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_cell_actions.CellActions, {
    field: _constants.SIGNAL_STATUS_FIELD_NAME,
    value: statusData.values[0]
  }, /*#__PURE__*/_react.default.createElement(_status_popover_button.StatusPopoverButton, {
    eventId: eventId,
    contextId: scopeId,
    enrichedFieldInfo: statusData,
    scopeId: scopeId,
    handleOnEventClosed: closeFlyout
  }))));
};
exports.DocumentStatus = DocumentStatus;
DocumentStatus.displayName = 'DocumentStatus';