"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _response_button = require("./response_button");
var _expandable_section = require("./expandable_section");
var _context = require("../context");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Most bottom section of the overview tab. It contains a summary of the response tab.
 */
const ResponseSection = ({
  expanded = false
}) => {
  const {
    isPreview
  } = (0, _context.useRightPanelContext)();
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.response.sectionTitle",
      defaultMessage: "Response"
    }),
    "data-test-subj": _test_ids.RESPONSE_SECTION_TEST_ID
  }, isPreview ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.response.previewMessage",
    defaultMessage: "Response is not available in alert preview."
  }) : /*#__PURE__*/_react.default.createElement(_response_button.ResponseButton, null));
};
exports.ResponseSection = ResponseSection;
ResponseSection.displayName = 'ResponseSection';