"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _status = require("./status");
var _severity = require("./severity");
var _risk_score = require("./risk_score");
var _use_refetch_by_scope = require("../../../../timelines/components/side_panel/event_details/flyout/use_refetch_by_scope");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _context = require("../context");
var _formatted_date = require("../../../../common/components/formatted_date");
var _formatted_field_helpers = require("../../../../timelines/components/timeline/body/renderers/formatted_field_helpers");
var _constants = require("../../../../timelines/components/timeline/body/renderers/constants");
var _test_ids = require("./test_ids");
var _assignees = require("./assignees");
var _flyout_title = require("../../../shared/components/flyout_title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details flyout right section header
 */
const HeaderTitle = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    eventId,
    scopeId,
    isPreview,
    refetchFlyoutData,
    getFieldsData
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    ruleName,
    timestamp,
    ruleId
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const ruleTitle = (0, _react.useMemo)(() => isPreview ? /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: ruleName,
    iconType: 'warning',
    "data-test-subj": _test_ids.FLYOUT_HEADER_TITLE_TEST_ID
  }) : /*#__PURE__*/_react.default.createElement(_formatted_field_helpers.RenderRuleName, {
    contextId: scopeId,
    eventId: eventId,
    fieldName: _constants.SIGNAL_RULE_NAME_FIELD_NAME,
    fieldType: 'string',
    isAggregatable: false,
    isDraggable: false,
    linkValue: ruleId,
    value: ruleName,
    openInNewTab: true
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: ruleName,
    iconType: 'warning',
    isLink: true,
    "data-test-subj": _test_ids.FLYOUT_HEADER_TITLE_TEST_ID
  })), [ruleName, ruleId, eventId, scopeId, isPreview]);
  const eventTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.headerTitle",
    defaultMessage: "Event details"
  })));
  const {
    refetch
  } = (0, _use_refetch_by_scope.useRefetchByScope)({
    scopeId
  });
  const alertAssignees = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = getFieldsData(_ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS)) !== null && _ref !== void 0 ? _ref : [];
  }, [getFieldsData]);
  const onAssigneesUpdated = (0, _react.useCallback)(() => {
    refetch();
    refetchFlyoutData();
  }, [refetch, refetchFlyoutData]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_severity.DocumentSeverity, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), timestamp && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.FLYOUT_HEADER_TITLE_TEST_ID
  }, isAlert && !(0, _lodash.isEmpty)(ruleName) ? ruleTitle : eventTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    responsive: false
  }, isAlert && !isPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_status.DocumentStatus, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_risk_score.RiskScore, null)), isAlert && !isPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_assignees.Assignees, {
    eventId: eventId,
    assignedUserIds: alertAssignees,
    onAssigneesUpdated: onAssigneesUpdated
  }))));
});
exports.HeaderTitle = HeaderTitle;
HeaderTitle.displayName = 'HeaderTitle';