"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntitiesOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _context = require("../context");
var _utils = require("../../shared/utils");
var _host_entity_overview = require("./host_entity_overview");
var _user_entity_overview = require("./user_entity_overview");
var _left = require("../../left");
var _entities_details = require("../../left/components/entities_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Entities section under Insights section, overview tab. It contains a preview of host and user information.
 */
const EntitiesOverview = () => {
  const {
    eventId,
    getFieldsData,
    indexName,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const hostName = (0, _utils.getField)(getFieldsData('host.name'));
  const userName = (0, _utils.getField)(getFieldsData('user.name'));
  const goToEntitiesTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.DocumentDetailsLeftPanelKey,
      path: {
        tab: _left.LeftPanelInsightsTab,
        subTab: _entities_details.ENTITIES_TAB_ID
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.entities.entitiesTitle",
        defaultMessage: "Entities"
      }),
      link: {
        callback: goToEntitiesTab,
        tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.flyout.right.insights.entities.entitiesTooltip",
          defaultMessage: "Show all entities"
        })
      },
      iconType: 'arrowStart'
    },
    "data-test-subj": _test_ids.INSIGHTS_ENTITIES_TEST_ID
  }, userName || hostName ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false
  }, userName && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_user_entity_overview.UserEntityOverview, {
    userName: userName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), hostName && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_host_entity_overview.HostEntityOverview, {
    hostName: hostName
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.entities.noDataDescription",
    defaultMessage: "Host and user information are unavailable for this alert."
  })));
};
exports.EntitiesOverview = EntitiesOverview;
EntitiesOverview.displayName = 'EntitiesOverview';