"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Description = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _context = require("../context");
var _helpers = require("../../../../timelines/components/side_panel/event_details/helpers");
var _test_ids = require("./test_ids");
var _preview = require("../../preview");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Displays the description of a document.
 * If the document is an alert we show the rule description. If the document is of another type, we show -.
 */
const Description = () => {
  const {
    dataFormattedForFieldBrowser,
    scopeId,
    eventId,
    indexName,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const {
    isAlert,
    ruleDescription,
    ruleName,
    ruleId
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const openRulePreview = (0, _react.useCallback)(() => {
    const PreviewPanelRulePreview = {
      tab: _preview.RulePreviewPanel
    };
    openPreviewPanel({
      id: _preview.DocumentDetailsPreviewPanelKey,
      path: PreviewPanelRulePreview,
      params: {
        id: eventId,
        indexName,
        scopeId,
        banner: {
          title: _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.description.rulePreviewTitle', {
            defaultMessage: 'Preview rule details'
          }),
          backgroundColor: 'warning',
          textColor: 'warning'
        },
        ruleId
      }
    });
  }, [eventId, openPreviewPanel, indexName, scopeId, ruleId]);
  const viewRule = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "expand",
    onClick: openRulePreview,
    iconSide: "right",
    "data-test-subj": _test_ids.RULE_SUMMARY_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.about.description.ruleSummaryButtonAriaLabel', {
      defaultMessage: 'Show rule summary'
    }),
    disabled: (0, _lodash.isEmpty)(ruleName) || (0, _lodash.isEmpty)(ruleId) || isPreview
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.ruleSummaryButtonLabel",
    defaultMessage: "Show rule summary"
  }))), [ruleName, openRulePreview, ruleId, isPreview]);
  const alertRuleDescription = (ruleDescription === null || ruleDescription === void 0 ? void 0 : ruleDescription.length) > 0 ? ruleDescription : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.noRuleDescription",
    defaultMessage: "There's no description for this rule."
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.DESCRIPTION_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, isAlert ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.ruleTitle",
    defaultMessage: "Rule description"
  }))), viewRule) : /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.description.documentTitle",
    defaultMessage: "Document description"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.DESCRIPTION_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("p", {
    css: (0, _react2.css)`
            word-break: break-word;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
          `
  }, isAlert ? alertRuleDescription : '-')));
};
exports.Description = Description;
Description.displayName = 'Description';