"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignees = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _empty_value = require("../../../../common/components/empty_value");
var _use_upselling = require("../../../../common/hooks/use_upselling");
var _use_license = require("../../../../common/hooks/use_license");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _use_bulk_get_user_profiles = require("../../../../common/components/user_profiles/use_bulk_get_user_profiles");
var _utils = require("../../../../common/components/assignees/utils");
var _assignees_popover = require("../../../../common/components/assignees/assignees_popover");
var _users_avatars_panel = require("../../../../common/components/user_profiles/users_avatars_panel");
var _use_set_alert_assignees = require("../../../../common/components/toolbar/bulk_actions/use_set_alert_assignees");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdateAssigneesButton = /*#__PURE__*/(0, _react.memo)(({
  togglePopover,
  isDisabled,
  toolTipMessage
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: toolTipMessage
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": "Update assignees",
  "data-test-subj": _test_ids.ASSIGNEES_ADD_BUTTON_TEST_ID,
  iconType: 'plusInCircle',
  onClick: togglePopover,
  isDisabled: isDisabled
})));
UpdateAssigneesButton.displayName = 'UpdateAssigneesButton';
/**
 * Document assignees details displayed in flyout right section header
 */
const Assignees = /*#__PURE__*/(0, _react.memo)(({
  eventId,
  assignedUserIds,
  onAssigneesUpdated,
  isPreview
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const upsellingMessage = (0, _use_upselling.useUpsellingMessage)('alert_assignments');
  const {
    hasIndexWrite
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const setAlertAssignees = (0, _use_set_alert_assignees.useSetAlertAssignees)();
  const uids = (0, _react.useMemo)(() => new Set(assignedUserIds), [assignedUserIds]);
  const {
    data: assignedUsers
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids
  });
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onSuccess = (0, _react.useCallback)(() => {
    if (onAssigneesUpdated) onAssigneesUpdated();
  }, [onAssigneesUpdated]);
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(value => !value);
  }, []);
  const onAssigneesApply = (0, _react.useCallback)(async assigneesIds => {
    setIsPopoverOpen(false);
    if (setAlertAssignees) {
      const updatedIds = (0, _utils.removeNoAssigneesSelection)(assigneesIds);
      const assigneesToAddArray = updatedIds.filter(uid => !assignedUserIds.includes(uid));
      const assigneesToRemoveArray = assignedUserIds.filter(uid => !updatedIds.includes(uid));
      const assigneesToUpdate = {
        add: assigneesToAddArray,
        remove: assigneesToRemoveArray
      };
      await setAlertAssignees(assigneesToUpdate, [eventId], onSuccess, _lodash.noop);
    }
  }, [assignedUserIds, eventId, onSuccess, setAlertAssignees]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_ids.ASSIGNEES_HEADER_TEST_ID,
    alignItems: "center",
    direction: "row",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": _test_ids.ASSIGNEES_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.assignedTitle",
    defaultMessage: "Assignees:"
  })))), isPreview ? (0, _empty_value.getEmptyTagValue)() : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false
  }, assignedUsers && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_users_avatars_panel.UsersAvatarsPanel, {
    userProfiles: assignedUsers,
    maxVisibleAvatars: 2
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_assignees_popover.AssigneesPopover, {
    assignedUserIds: assignedUserIds,
    button: /*#__PURE__*/_react.default.createElement(UpdateAssigneesButton, {
      togglePopover: togglePopover,
      isDisabled: !hasIndexWrite || !isPlatinumPlus,
      toolTipMessage: upsellingMessage !== null && upsellingMessage !== void 0 ? upsellingMessage : _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.assignees.popoverTooltip', {
        defaultMessage: 'Assign alert'
      })
    }),
    isPopoverOpen: isPopoverOpen,
    closePopover: togglePopover,
    onAssigneesApply: onAssigneesApply
  }))));
});
exports.Assignees = Assignees;
Assignees.displayName = 'Assignees';