"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzerPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _test_ids = require("./test_ids");
var _analyzer_helpers = require("../utils/analyzer_helpers");
var _field_names = require("../../shared/constants/field_names");
var _context = require("../context");
var _use_alert_prevalence_from_process_tree = require("../../../../common/containers/alerts/use_alert_prevalence_from_process_tree");
var _helpers = require("../../../../helpers");
var _utils = require("../../shared/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHILD_COUNT_LIMIT = 3;
const ANCESTOR_LEVEL = 3;
const DESCENDANT_LEVEL = 3;

/**
 * Cache that stores fetched stats nodes
 */

/**
 * Analyzer preview under Overview, Visualizations. It shows a tree representation of analyzer.
 */
const AnalyzerPreview = () => {
  var _getField, _index$values;
  const [cache, setCache] = (0, _react.useState)({});
  const {
    dataFormattedForFieldBrowser: data,
    getFieldsData,
    scopeId,
    eventId,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const ancestorId = (_getField = (0, _utils.getField)(getFieldsData(_field_names.ANCESTOR_ID))) !== null && _getField !== void 0 ? _getField : '';
  const documentId = isPreview ? ancestorId : eventId; // use ancestor as fallback for alert preview

  const index = (0, _fp.find)({
    category: 'kibana',
    field: _field_names.RULE_INDICES
  }, data);
  const indices = (_index$values = index === null || index === void 0 ? void 0 : index.values) !== null && _index$values !== void 0 ? _index$values : [];
  const {
    statsNodes,
    loading,
    error
  } = (0, _use_alert_prevalence_from_process_tree.useAlertPrevalenceFromProcessTree)({
    isActiveTimeline: (0, _helpers.isActiveTimeline)(scopeId),
    documentId,
    indices
  });
  (0, _react.useEffect)(() => {
    if (statsNodes && statsNodes.length !== 0) {
      setCache({
        statsNodes
      });
    }
  }, [statsNodes, setCache]);
  const items = (0, _react.useMemo)(() => {
    var _cache$statsNodes;
    return (0, _analyzer_helpers.getTreeNodes)((_cache$statsNodes = cache.statsNodes) !== null && _cache$statsNodes !== void 0 ? _cache$statsNodes : [], CHILD_COUNT_LIMIT, ANCESTOR_LEVEL, DESCENDANT_LEVEL);
  }, [cache.statsNodes]);
  const showAnalyzerTree = eventId && index && items && items.length > 0 && !error;
  return loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": _test_ids.ANALYZER_PREVIEW_LOADING_TEST_ID,
    contentAriaLabel: _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.analyzerPreview.loadingAriaLabel', {
      defaultMessage: 'analyzer preview'
    })
  }) : showAnalyzerTree ? /*#__PURE__*/_react.default.createElement(_eui.EuiTreeView, {
    items: items,
    display: "compressed",
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.analyzerPreview.treeViewAriaLabel', {
      defaultMessage: 'Analyzer preview'
    }),
    showExpansionArrows: true,
    "data-test-subj": _test_ids.ANALYZER_PREVIEW_TEST_ID
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.visualizations.analyzerPreview.errorDescription",
    defaultMessage: "An error is preventing this alert from being analyzed."
  });
};
exports.AnalyzerPreview = AnalyzerPreview;
AnalyzerPreview.displayName = 'AnalyzerPreview';