"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewPanelContext = exports.PreviewPanelProvider = exports.PreviewPanelContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_event_details = require("../shared/hooks/use_event_details");
var _flyout_error = require("../../shared/components/flyout_error");
var _flyout_loading = require("../../shared/components/flyout_loading");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PreviewPanelContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.PreviewPanelContext = PreviewPanelContext;
const PreviewPanelProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  indexName,
  scopeId,
  ruleId,
  children
}) => {
  const {
    dataAsNestedObject,
    indexPattern,
    loading
  } = (0, _use_event_details.useEventDetails)({
    eventId: id,
    indexName
  });
  const contextValue = (0, _react.useMemo)(() => id && indexName && scopeId && dataAsNestedObject ? {
    eventId: id,
    indexName,
    scopeId,
    ruleId: ruleId !== null && ruleId !== void 0 ? ruleId : '',
    indexPattern,
    dataAsNestedObject
  } : undefined, [id, indexName, scopeId, ruleId, indexPattern, dataAsNestedObject]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, null);
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, null);
  }
  return /*#__PURE__*/_react.default.createElement(PreviewPanelContext.Provider, {
    value: contextValue
  }, children);
});
exports.PreviewPanelProvider = PreviewPanelProvider;
PreviewPanelProvider.displayName = 'PreviewPanelProvider';
const usePreviewPanelContext = () => {
  const contextValue = (0, _react.useContext)(PreviewPanelContext);
  if (!contextValue) {
    throw new Error('PreviewPanelContext can only be used within PreviewPanelContext provider');
  }
  return contextValue;
};
exports.usePreviewPanelContext = usePreviewPanelContext;