"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../detection_engine/rule_details_ui/pages/rule_details/translations");
var _rule_info = require("../../../../detections/components/rules/rule_info");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Title component that shows basic information of a rule. This is displayed above rule preview body in rule preview panel
 */
const RulePreviewTitle = ({
  rule,
  isSuppressed
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.RULE_PREVIEW_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h6", null, rule.name)), isSuppressed && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": _test_ids.RULE_PREVIEW_RULE_TITLE_SUPPRESSED_TEST_ID,
    title: ""
  }, _translations.DELETED_RULE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.RULE_PREVIEW_RULE_CREATED_BY_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_rule_info.CreatedBy, {
    createdBy: rule === null || rule === void 0 ? void 0 : rule.created_by,
    createdAt: rule === null || rule === void 0 ? void 0 : rule.created_at
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.RULE_PREVIEW_RULE_UPDATED_BY_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_rule_info.UpdatedBy, {
    updatedBy: rule === null || rule === void 0 ? void 0 : rule.updated_by,
    updatedAt: rule === null || rule === void 0 ? void 0 : rule.updated_at
  })))));
};
exports.RulePreviewTitle = RulePreviewTitle;
RulePreviewTitle.displayName = 'RulePreviewTitle';