"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserRiskScoreQueryTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _enable_risk_score = require("../../../components/risk_score/enable_risk_score");
var _manage_query = require("../../../../common/components/page/manage_query");
var _use_selector = require("../../../../common/hooks/use_selector");
var _user_risk_score_table = require("../../components/user_risk_score_table");
var _store = require("../../store");
var _risk_score = require("../../../containers/risk_score");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _search_strategy = require("../../../../../common/search_strategy");
var _risk_score_no_data_detected = require("../../../components/risk_score/risk_score_onboarding/risk_score_no_data_detected");
var _use_risk_engine_status = require("../../../../entity_analytics/api/hooks/use_risk_engine_status");
var _risk_score_update_panel = require("../../../../entity_analytics/components/risk_score_update_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserRiskScoreTableManage = (0, _manage_query.manageQuery)(_user_risk_score_table.UserRiskScoreTable);
const UserRiskScoreQueryTabBody = ({
  deleteQuery,
  endDate: to,
  filterQuery,
  setQuery,
  skip,
  startDate: from,
  type
}) => {
  const {
    data: riskScoreEngineStatus
  } = (0, _use_risk_engine_status.useRiskEngineStatus)();
  const getUserRiskScoreSelector = (0, _react.useMemo)(() => _store.usersSelectors.userRiskScoreSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getUserRiskScoreSelector(state));
  const getUserRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store.usersSelectors.userRiskScoreSeverityFilterSelector(), []);
  const userSeveritySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => getUserRiskScoreFilterQuerySelector(state));
  const pagination = (0, _react.useMemo)(() => ({
    cursorStart: activePage * limit,
    querySize: limit
  }), [activePage, limit]);
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_risk_score.UserRiskScoreQueryId.USERS_BY_RISK);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const {
    data,
    inspect,
    isDeprecated,
    isInspected,
    isModuleEnabled,
    loading,
    refetch,
    totalCount
  } = (0, _risk_score.useRiskScore)({
    filterQuery,
    pagination,
    riskEntity: _search_strategy.RiskScoreEntity.user,
    skip: querySkip,
    sort,
    timerange
  });
  const {
    severityCount,
    loading: isKpiLoading
  } = (0, _risk_score.useRiskScoreKpi)({
    filterQuery,
    riskEntity: _search_strategy.RiskScoreEntity.user,
    skip: querySkip
  });
  const status = {
    isDisabled: !isModuleEnabled && !loading,
    isDeprecated: isDeprecated && !loading
  };
  if (status.isDisabled || status.isDeprecated) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, (0, _extends2.default)({}, status, {
      entityType: _search_strategy.RiskScoreEntity.user,
      refetch: refetch,
      timerange: timerange
    }));
  }
  if (isModuleEnabled && userSeveritySelectionRedux.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: _search_strategy.RiskScoreEntity.user,
      refetch: refetch
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (riskScoreEngineStatus === null || riskScoreEngineStatus === void 0 ? void 0 : riskScoreEngineStatus.isUpdateAvailable) && /*#__PURE__*/_react.default.createElement(_risk_score_update_panel.RiskScoreUpdatePanel, null), /*#__PURE__*/_react.default.createElement(UserRiskScoreTableManage, {
    deleteQuery: deleteQuery,
    data: data !== null && data !== void 0 ? data : [],
    id: _risk_score.UserRiskScoreQueryId.USERS_BY_RISK,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading || isKpiLoading,
    loadPage: _fp.noop // It isn't necessary because PaginatedTable updates redux store and we load the page when activePage updates on the store
    ,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    severityCount: severityCount !== null && severityCount !== void 0 ? severityCount : _search_strategy.EMPTY_SEVERITY_COUNT,
    totalCount: totalCount,
    type: type
  }));
};
exports.UserRiskScoreQueryTabBody = UserRiskScoreQueryTabBody;
UserRiskScoreQueryTabBody.displayName = 'UserRiskScoreQueryTabBody';