"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userNameExistsFilter = exports.getUsersDetailsPageFilters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUsersDetailsPageFilters = userName => [{
  meta: {
    alias: null,
    negate: false,
    disabled: false,
    type: 'phrase',
    key: 'user.name',
    value: userName,
    params: {
      query: userName
    }
  },
  query: {
    match: {
      'user.name': {
        query: userName,
        type: 'phrase'
      }
    }
  }
}];
exports.getUsersDetailsPageFilters = getUsersDetailsPageFilters;
const userNameExistsFilter = [{
  query: {
    bool: {
      filter: [{
        bool: {
          should: [{
            exists: {
              field: 'user.name'
            }
          }],
          minimum_should_match: 1
        }
      }]
    }
  },
  meta: {
    alias: '',
    disabled: false,
    key: 'bool',
    negate: false,
    type: 'custom',
    value: '{"query": {"bool": {"filter": [{"bool": {"should": [{"exists": {"field": "user.name"}}],"minimum_should_match": 1}}]}}}'
  }
}];
exports.userNameExistsFilter = userNameExistsFilter;