"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useObservedUserDetails = exports.OBSERVED_USER_QUERY_ID = void 0;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _users = require("../../../../../../common/search_strategy/security_solution/users");
var _common = require("../../../../../../common/search_strategy/security_solution/users/common");
var _use_search_strategy = require("../../../../../common/containers/use_search_strategy");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OBSERVED_USER_QUERY_ID = 'observedUsersDetailsQuery';
exports.OBSERVED_USER_QUERY_ID = OBSERVED_USER_QUERY_ID;
const useObservedUserDetails = ({
  endDate,
  userName,
  indexNames,
  id = OBSERVED_USER_QUERY_ID,
  skip = false,
  startDate
}) => {
  const isNewUserDetailsFlyoutEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newUserDetailsFlyout');
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _users.UsersQueries.observedDetails,
    initialResult: {
      userDetails: {}
    },
    errorMessage: i18n.FAIL_USER_DETAILS,
    abort: skip
  });
  const userDetailsResponse = (0, _react.useMemo)(() => ({
    endDate,
    userDetails: response.userDetails,
    id,
    inspect,
    refetch,
    startDate
  }), [endDate, id, inspect, refetch, response.userDetails, startDate]);
  const userDetailsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _users.UsersQueries.observedDetails,
    userName,
    timerange: {
      interval: '12h',
      from: startDate,
      to: endDate
    },
    filterQuery: isNewUserDetailsFlyoutEnabled ? _common.NOT_EVENT_KIND_ASSET_FILTER : undefined
  }), [endDate, indexNames, startDate, userName, isNewUserDetailsFlyoutEnabled]);
  (0, _react.useEffect)(() => {
    if (!skip) {
      search(userDetailsRequest);
    }
  }, [userDetailsRequest, search, skip]);
  return [loading, userDetailsResponse];
};
exports.useObservedUserDetails = useObservedUserDetails;