"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsMapping = exports.UsersKpiAuthentications = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kpi_user_authentications_area = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentications_area");
var _kpi_user_authentications_bar = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentications_bar");
var _kpi_user_authentications_metric_success = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentications_metric_success");
var _kpi_user_authentication_metric_failure = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_user_authentication_metric_failure");
var _authentications = require("../../../containers/users/authentications");
var _common = require("../../../../hosts/components/kpi_hosts/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _constants = require("../../../../../common/store/inputs/constants");
var _use_refetch_by_session = require("../../../../../common/components/page/use_refetch_by_session");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var ChartColors;
(function (ChartColors) {
  ChartColors["authenticationsSuccess"] = "#54B399";
  ChartColors["authenticationsFailure"] = "#E7664C";
})(ChartColors || (ChartColors = {}));
const fieldsMapping = [{
  key: 'authentication',
  fields: [{
    key: 'authenticationsSuccess',
    name: i18n.SUCCESS_CHART_LABEL,
    description: i18n.SUCCESS_UNIT_LABEL,
    value: null,
    color: ChartColors.authenticationsSuccess,
    icon: 'check',
    lensAttributes: _kpi_user_authentications_metric_success.kpiUserAuthenticationsMetricSuccessLensAttributes
  }, {
    key: 'authenticationsFailure',
    name: i18n.FAIL_CHART_LABEL,
    description: i18n.FAIL_UNIT_LABEL,
    value: null,
    color: ChartColors.authenticationsFailure,
    icon: 'cross',
    lensAttributes: _kpi_user_authentication_metric_failure.kpiUserAuthenticationsMetricFailureLensAttributes
  }],
  enableAreaChart: true,
  enableBarChart: true,
  description: i18n.USER_AUTHENTICATIONS,
  areaChartLensAttributes: _kpi_user_authentications_area.kpiUserAuthenticationsAreaLensAttributes,
  barChartLensAttributes: _kpi_user_authentications_bar.kpiUserAuthenticationsBarLensAttributes
}];
exports.fieldsMapping = fieldsMapping;
const UsersKpiAuthenticationsComponent = ({
  filterQuery,
  from,
  indexNames,
  to,
  updateDateRange,
  setQuery,
  skip
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_authentications.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    refetch,
    id,
    inspect,
    ...data
  }] = (0, _authentications.useUsersKpiAuthentications)({
    filterQuery,
    endDate: to,
    indexNames,
    startDate: from,
    skip: querySkip || isChartEmbeddablesEnabled
  });
  const {
    session,
    refetchByRestartingSession
  } = (0, _use_refetch_by_session.useRefetchByRestartingSession)({
    inputId: _constants.InputsModelId.global,
    queryId: id
  });
  return /*#__PURE__*/_react.default.createElement(_common.KpiBaseComponentManage, {
    data: data,
    id: id,
    inspect: inspect,
    loading: loading,
    fieldsMapping: fieldsMapping,
    from: from,
    to: to,
    updateDateRange: updateDateRange,
    refetch: isChartEmbeddablesEnabled ? refetchByRestartingSession : refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    session: isChartEmbeddablesEnabled ? session : undefined
  });
};
UsersKpiAuthenticationsComponent.displayName = 'UsersKpiAuthenticationsComponent';
const UsersKpiAuthentications = /*#__PURE__*/_react.default.memo(UsersKpiAuthenticationsComponent);
exports.UsersKpiAuthentications = UsersKpiAuthentications;