"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIpFieldPopulated = exports.hasPorts = exports.getPorts = exports.SourceDestinationIp = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _ip = require("../ip");
var _port = require("../port");
var _helpers = require("../port/helpers");
var i18n = _interopRequireWildcard(require("../../../../timelines/components/timeline/body/renderers/translations"));
var _geo_fields = require("./geo_fields");
var _ip_with_port = require("./ip_with_port");
var _label = require("./label");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns `true` if the ip field (i.e. `sourceIp`, `destinationIp`) that
 * corresponds with the specified `type` (i.e. `source`, `destination`) is
 * populated. This function will return `false` when the array only contains
 * empty values.
 */
const isIpFieldPopulated = ({
  destinationIp,
  sourceIp,
  type
}) => type === 'source' && sourceIp != null && sourceIp.some(ip => !(0, _fp.isEmpty)(ip)) || type === 'destination' && destinationIp != null && destinationIp.some(ip => !(0, _fp.isEmpty)(ip));

/**
 * Returns an array of ports, filtered such that `null` entries are removed. If
 * the provided `destinationPort` and `sourcePort` do not contain valid ports,
 * an empty array will be returned.
 */
exports.isIpFieldPopulated = isIpFieldPopulated;
const getPorts = ({
  destinationPort,
  sourcePort,
  type
}) => {
  const ports = type === 'source' && sourcePort != null ? sourcePort : type === 'destination' && destinationPort != null ? destinationPort : [];
  return ports.filter(p => p != null).map(p => `${p}`).filter(p => !(0, _fp.isEmpty)(p));
};

/**
 * Returns `true` if the array of ports, filtered to remove invalid entries,
 * has at least one port.
 */
exports.getPorts = getPorts;
const hasPorts = ({
  destinationPort,
  sourcePort,
  type
}) => getPorts({
  destinationPort,
  sourcePort,
  type
}).length > 0;
exports.hasPorts = hasPorts;
const IpAdressesWithPorts = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationIp,
  destinationPort,
  eventId,
  isDraggable,
  sourceIp,
  sourcePort,
  type
}) => {
  const ip = type === 'source' ? sourceIp : destinationIp;
  const ipFieldName = type === 'source' ? _ip.SOURCE_IP_FIELD_NAME : _ip.DESTINATION_IP_FIELD_NAME;
  const port = type === 'source' ? sourcePort : destinationPort;
  const portFieldName = type === 'source' ? _helpers.SOURCE_PORT_FIELD_NAME : _helpers.DESTINATION_PORT_FIELD_NAME;
  if (ip == null) {
    return null; // if ip is not populated as an array, ports will be ignored
  }

  // IMPORTANT: The ip and port arrays are parallel arrays; the port at
  // index `i` corresponds with the ip address at index `i`. We must
  // preserve the relationships between the parallel arrays:
  const ipPortPairs = port != null && ip.length === port.length ? ip.map((address, i) => ({
    ip: address,
    port: port[i] != null ? `${port[i]}` : null // use the corresponding port in the parallel array
  })) : ip.map(address => ({
    ip: address,
    port: null // drop the port, because the length of the parallel ip and port arrays is different
  }));

  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, (0, _fp.uniqWith)(_fastDeepEqual.default, ipPortPairs).map(ipPortPair => ipPortPair.ip != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: ipPortPair.ip
  }, /*#__PURE__*/_react.default.createElement(_ip_with_port.IpWithPort, {
    contextId: contextId,
    "data-test-subj": `${type}-ip-and-port`,
    eventId: eventId,
    ip: ipPortPair.ip,
    ipFieldName: ipFieldName,
    isDraggable: isDraggable,
    port: ipPortPair.port,
    portFieldName: portFieldName
  }))));
});
IpAdressesWithPorts.displayName = 'IpAdressesWithPorts';

/**
 * When the ip field (i.e. `sourceIp`, `destinationIp`) that corresponds with
 * the specified `type` (i.e. `source`, `destination`) is populated, this component
 * renders:
 * - a label (i.e. `Source` or `Destination`)
 * - a draggable / hyperlinked IP address, when it's populated
 * - a port, hyperlinked to a port lookup service, when it's populated
 * - a summary of geolocation details, when they are populated
 */
const SourceDestinationIp = /*#__PURE__*/_react.default.memo(({
  contextId,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPort,
  eventId,
  isDraggable,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourceIp,
  sourcePort,
  type
}) => {
  const label = type === 'source' ? i18n.SOURCE : i18n.DESTINATION;
  return isIpFieldPopulated({
    destinationIp,
    sourceIp,
    type
  }) || hasPorts({
    destinationPort,
    sourcePort,
    type
  }) ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": `${type}-ip-badge`,
    color: "hollow",
    title: ""
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": `${type}-ip-group`,
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_label.Label, null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isIpFieldPopulated({
    destinationIp,
    sourceIp,
    type
  }) ? /*#__PURE__*/_react.default.createElement(IpAdressesWithPorts, {
    contextId: contextId,
    destinationIp: destinationIp,
    destinationPort: destinationPort,
    eventId: eventId,
    isDraggable: isDraggable,
    sourceIp: sourceIp,
    sourcePort: sourcePort,
    type: type
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, getPorts({
    destinationPort,
    sourcePort,
    type
  }).map((port, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `port-${port}-${i}`,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_port.Port, {
    contextId: contextId,
    "data-test-subj": "port",
    eventId: eventId,
    fieldName: `${type}.port`,
    isDraggable: isDraggable,
    value: port
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_geo_fields.GeoFields, {
    contextId: contextId,
    destinationGeoContinentName: destinationGeoContinentName,
    destinationGeoCountryName: destinationGeoCountryName,
    destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
    destinationGeoRegionName: destinationGeoRegionName,
    destinationGeoCityName: destinationGeoCityName,
    eventId: eventId,
    isDraggable: isDraggable,
    sourceGeoContinentName: sourceGeoContinentName,
    sourceGeoCountryName: sourceGeoCountryName,
    sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
    sourceGeoRegionName: sourceGeoRegionName,
    sourceGeoCityName: sourceGeoCityName,
    type: type
  })))) : null;
});
exports.SourceDestinationIp = SourceDestinationIp;
SourceDestinationIp.displayName = 'SourceDestinationIp';