"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpWithPort = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _ip = require("../ip");
var _port = require("../port");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IpPortSeparator = _styledComponents.default.span`
  margin: 0 3px;
`;
IpPortSeparator.displayName = 'IpPortSeparator';

/**
 * Renders a separator (i.e. `:`) and a draggable, hyperlinked port when
 * a port is specified
 */
const PortWithSeparator = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  isDraggable,
  port,
  portFieldName
}) => {
  return port != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(IpPortSeparator, {
    "data-test-subj": "ip-port-separator"
  }, ':')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_port.Port, {
    contextId: contextId,
    "data-test-subj": "port",
    eventId: eventId,
    fieldName: portFieldName,
    isDraggable: isDraggable,
    value: port
  }))) : null;
});
PortWithSeparator.displayName = 'PortWithSeparator';

/**
 * Renders a draggable, hyperlinked IP address, and if provided, an associated
 * draggable, hyperlinked port (with a separator between the IP address and port)
 */
const IpWithPort = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  ip,
  ipFieldName,
  isDraggable,
  port,
  portFieldName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_ip.Ip, {
  contextId: contextId,
  "data-test-subj": "ip",
  eventId: eventId,
  fieldName: ipFieldName,
  isDraggable: isDraggable,
  value: ip
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(PortWithSeparator, {
  contextId: contextId,
  eventId: eventId,
  isDraggable: isDraggable,
  port: port,
  portFieldName: portFieldName
}))));
exports.IpWithPort = IpWithPort;
IpWithPort.displayName = 'IpWithPort';