"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.SOURCE_IPS = exports.SOURCE_IP = exports.ROWS_5 = exports.ROWS_10 = exports.IP_TITLE = exports.FLOWS = exports.DOMAIN = exports.DESTINATION_IPS = exports.DESTINATION_IP = exports.BYTES_OUT = exports.BYTES_IN = exports.AUTONOMOUS_SYSTEM = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {IP} other {IPs}}`
});
exports.UNIT = UNIT;
const SOURCE_IP = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.sourceIpTitle', {
  defaultMessage: 'Source IPs'
});
exports.SOURCE_IP = SOURCE_IP;
const DESTINATION_IP = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.destinationIpTitle', {
  defaultMessage: 'Destination IPs'
});
exports.DESTINATION_IP = DESTINATION_IP;
const IP_TITLE = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.IpTitle', {
  defaultMessage: 'IP'
});
exports.IP_TITLE = IP_TITLE;
const DOMAIN = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.domainTitle', {
  defaultMessage: 'Domain'
});
exports.DOMAIN = DOMAIN;
const BYTES_IN = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.bytesInTitle', {
  defaultMessage: 'Bytes in'
});
exports.BYTES_IN = BYTES_IN;
const BYTES_OUT = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.bytesOutTitle', {
  defaultMessage: 'Bytes out'
});
exports.BYTES_OUT = BYTES_OUT;
const AUTONOMOUS_SYSTEM = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.column.asTitle', {
  defaultMessage: 'Autonomous system'
});
exports.AUTONOMOUS_SYSTEM = AUTONOMOUS_SYSTEM;
const FLOWS = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.flows', {
  defaultMessage: 'Flows'
});
exports.FLOWS = FLOWS;
const DESTINATION_IPS = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.destinationIps', {
  defaultMessage: 'Destination IPs'
});
exports.DESTINATION_IPS = DESTINATION_IPS;
const SOURCE_IPS = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.sourceIps', {
  defaultMessage: 'Source IPs'
});
exports.SOURCE_IPS = SOURCE_IPS;
const ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_5 = ROWS_5;
const ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.networkTopNFlowTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_10 = ROWS_10;