"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkHttpTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _store = require("../../store");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_selector = require("../../../../common/hooks/use_selector");
var _paginated_table = require("../../../components/paginated_table");
var _columns = require("./columns");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const NetworkHttpTableComponent = ({
  data,
  fakeTotalCount,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  showMorePagesIndicator,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getNetworkHttpSelector = (0, _react.useMemo)(() => _store.networkSelectors.httpSelector(), []);
  const {
    activePage,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(state => getNetworkHttpSelector(state, type));
  const tableType = type === _store.networkModel.NetworkType.page ? _store.networkModel.NetworkTableType.http : _store.networkModel.NetworkDetailsTableType.http;
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      limit: newLimit
    }
  })), [dispatch, type, tableType]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      activePage: newPage
    }
  })), [dispatch, type, tableType]);
  const onChange = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null && criteria.sort.direction !== sort.direction) {
      dispatch(_store.networkActions.updateNetworkTable({
        networkType: type,
        tableType,
        updates: {
          sort: {
            direction: criteria.sort.direction
          }
        }
      }));
    }
  }, [sort.direction, dispatch, type, tableType]);
  const sorting = {
    field: `node.${_search_strategy.NetworkHttpFields.requestCount}`,
    direction: sort.direction
  };
  const columns = (0, _react.useMemo)(() => (0, _columns.getNetworkHttpColumns)(tableType), [tableType]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: i18n.HTTP_REQUESTS,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    itemsPerRow: rowItems,
    isInspect: isInspect,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onChange,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: showMorePagesIndicator,
    sorting: sorting,
    totalCount: fakeTotalCount,
    updateActivePage: updateActivePage,
    updateLimitPagination: updateLimitPagination
  });
};
NetworkHttpTableComponent.displayName = 'NetworkHttpTableComponent';
const NetworkHttpTable = /*#__PURE__*/_react.default.memo(NetworkHttpTableComponent);
exports.NetworkHttpTable = NetworkHttpTable;