"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_LAYER = exports.SOURCE_IP = exports.SOURCE_DOMAIN = exports.SOURCE = exports.SERVER_LAYER = exports.SERVER_IP = exports.SERVER_DOMAIN = exports.SERVER = exports.MAP_TOOL_TIP_FEATURES_FOOTER = exports.MAP_TOOL_TIP_ERROR = exports.MAP_TITLE = exports.LOCATION = exports.LINE_LAYER = exports.HOST = exports.ERROR_TITLE = exports.ERROR_CREATING_EMBEDDABLE = exports.ERROR_BUTTON = exports.EMBEDDABLE_HEADER_TITLE = exports.EMBEDDABLE_HEADER_HELP = exports.DESTINATION_LAYER = exports.DESTINATION_IP = exports.DESTINATION_DOMAIN = exports.DESTINATION = exports.CLIENT_LAYER = exports.CLIENT_IP = exports.CLIENT_DOMAIN = exports.CLIENT = exports.ASN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMBEDDABLE_HEADER_TITLE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.embeddableHeaderTitle', {
  defaultMessage: 'Network map'
});
exports.EMBEDDABLE_HEADER_TITLE = EMBEDDABLE_HEADER_TITLE;
const EMBEDDABLE_HEADER_HELP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.embeddableHeaderHelp', {
  defaultMessage: 'Map configuration help'
});
exports.EMBEDDABLE_HEADER_HELP = EMBEDDABLE_HEADER_HELP;
const MAP_TITLE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.embeddablePanelTitle', {
  defaultMessage: 'Source -> Destination Point-to-Point Map'
});
exports.MAP_TITLE = MAP_TITLE;
const SOURCE_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.sourceLayerLabel', {
  defaultMessage: 'Source Point'
});
exports.SOURCE_LAYER = SOURCE_LAYER;
const DESTINATION_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.destinationLayerLabel', {
  defaultMessage: 'Destination Point'
});
exports.DESTINATION_LAYER = DESTINATION_LAYER;
const CLIENT_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.clientLayerLabel', {
  defaultMessage: 'Client Point'
});
exports.CLIENT_LAYER = CLIENT_LAYER;
const SERVER_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.serverLayerLabel', {
  defaultMessage: 'Server Point'
});
exports.SERVER_LAYER = SERVER_LAYER;
const LINE_LAYER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.lineLayerLabel', {
  defaultMessage: 'Line'
});
exports.LINE_LAYER = LINE_LAYER;
const ERROR_CREATING_EMBEDDABLE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.embeddedMap.errorCreatingMapEmbeddableTitle', {
  defaultMessage: 'Error creating Map Embeddable'
});
exports.ERROR_CREATING_EMBEDDABLE = ERROR_CREATING_EMBEDDABLE;
const ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.indexPatternsMissingPrompt.errorTitle', {
  defaultMessage: 'Required index patterns not configured'
});
exports.ERROR_TITLE = ERROR_TITLE;
const ERROR_BUTTON = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.indexPatternsMissingPrompt.errorButtonLabel', {
  defaultMessage: 'Configure index patterns'
});
exports.ERROR_BUTTON = ERROR_BUTTON;
const MAP_TOOL_TIP_ERROR = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.errorTitle', {
  defaultMessage: 'Error loading map features'
});
exports.MAP_TOOL_TIP_ERROR = MAP_TOOL_TIP_ERROR;
const MAP_TOOL_TIP_FEATURES_FOOTER = (currentFeature, totalFeatures) => _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.footerLabel', {
  values: {
    currentFeature,
    totalFeatures
  },
  defaultMessage: '{currentFeature} of {totalFeatures} {totalFeatures, plural, =1 {feature} other {features}}'
});
exports.MAP_TOOL_TIP_FEATURES_FOOTER = MAP_TOOL_TIP_FEATURES_FOOTER;
const HOST = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.hostTitle', {
  defaultMessage: 'Host'
});
exports.HOST = HOST;
const SOURCE_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.sourceIPTitle', {
  defaultMessage: 'Source IP'
});
exports.SOURCE_IP = SOURCE_IP;
const DESTINATION_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.destinationIPTitle', {
  defaultMessage: 'Destination IP'
});
exports.DESTINATION_IP = DESTINATION_IP;
const CLIENT_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.clientIPTitle', {
  defaultMessage: 'Client IP'
});
exports.CLIENT_IP = CLIENT_IP;
const SERVER_IP = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.serverIPTitle', {
  defaultMessage: 'Server IP'
});
exports.SERVER_IP = SERVER_IP;
const SOURCE_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.sourceDomainTitle', {
  defaultMessage: 'Source domain'
});
exports.SOURCE_DOMAIN = SOURCE_DOMAIN;
const DESTINATION_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.destinationDomainTitle', {
  defaultMessage: 'Destination domain'
});
exports.DESTINATION_DOMAIN = DESTINATION_DOMAIN;
const CLIENT_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.clientDomainTitle', {
  defaultMessage: 'Client domain'
});
exports.CLIENT_DOMAIN = CLIENT_DOMAIN;
const SERVER_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.serverDomainTitle', {
  defaultMessage: 'Server domain'
});
exports.SERVER_DOMAIN = SERVER_DOMAIN;
const LOCATION = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.locationTitle', {
  defaultMessage: 'Location'
});
exports.LOCATION = LOCATION;
const ASN = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.pointContent.asnTitle', {
  defaultMessage: 'ASN'
});
exports.ASN = ASN;
const SOURCE = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.sourceLabel', {
  defaultMessage: 'Source'
});
exports.SOURCE = SOURCE;
const DESTINATION = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.destinationLabel', {
  defaultMessage: 'Destination'
});
exports.DESTINATION = DESTINATION;
const CLIENT = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.clientLabel', {
  defaultMessage: 'Client'
});
exports.CLIENT = CLIENT;
const SERVER = _i18n.i18n.translate('xpack.securitySolution.components.embeddables.mapToolTip.lineContent.serverLabel', {
  defaultMessage: 'Server'
});
exports.SERVER = SERVER;