"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolTipFooterComponent = exports.ToolTipFooter = exports.Icon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Icon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: ${_uiTheme.euiLightVars.euiSizeS};
`;
exports.Icon = Icon;
Icon.displayName = 'Icon';
const ToolTipFooterComponent = ({
  featureIndex,
  totalFeatures,
  previousFeature,
  nextFeature
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, i18n.MAP_TOOL_TIP_FEATURES_FOOTER(featureIndex + 1, totalFeatures))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": 'previous-feature-button',
    color: 'text',
    onClick: previousFeature,
    iconType: "arrowLeft",
    "aria-label": "Next",
    isDisabled: featureIndex <= 0
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": 'next-feature-button',
    color: 'text',
    onClick: nextFeature,
    iconType: "arrowRight",
    "aria-label": "Next",
    isDisabled: featureIndex >= totalFeatures - 1
  })))));
};
exports.ToolTipFooterComponent = ToolTipFooterComponent;
ToolTipFooterComponent.displayName = 'ToolTipFooterComponent';
const ToolTipFooter = /*#__PURE__*/_react.default.memo(ToolTipFooterComponent);
exports.ToolTipFooter = ToolTipFooter;
ToolTipFooter.displayName = 'ToolTipFooter';