"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NETWORK_MAP_VISIBLE = exports.EmbeddedMapComponent = exports.EmbeddedMap = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _public = require("@kbn/embeddable-plugin/public");
var _fp = require("lodash/fp");
var _helpers = require("../../../../detections/components/alerts_table/helpers");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _fields = require("../../../containers/fields");
var _loader = require("../../../../common/components/loader");
var _embeddable = require("./embeddable");
var _create_embeddable = require("./create_embeddable");
var _index_patterns_missing_prompt = require("./index_patterns_missing_prompt");
var _map_tool_tip = require("./map_tool_tip/map_tool_tip");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _map_config = require("./map_config");
var _sourcerer = require("../../../../common/store/sourcerer");
var _model = require("../../../../common/store/sourcerer/model");
var _use_selector = require("../../../../common/hooks/use_selector");
var _sourcerer2 = require("../../../../common/containers/sourcerer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// embedded map v2

const NETWORK_MAP_VISIBLE = 'network_map_visbile';
exports.NETWORK_MAP_VISIBLE = NETWORK_MAP_VISIBLE;
const EmbeddableMap = _styledComponents.default.div.attrs(() => ({
  className: 'siemEmbeddable__map'
}))`
  .embPanel {
    border: none;
    box-shadow: none;
  }

  .mapToolbarOverlay__button {
    display: none;
  }

  ${({
  maintainRatio
}) => maintainRatio && (0, _styledComponents.css)`
      padding-top: calc(3 / 4 * 100%); /* 4:3 (standard) ratio */
      position: relative;

      @media only screen and (min-width: ${({
  theme
}) => theme.eui.euiBreakpoints.m}) {
        padding-top: calc(9 / 32 * 100%); /* 32:9 (ultra widescreen) ratio */
      }

      @media only screen and (min-width: 1441px) and (min-height: 901px) {
        padding-top: calc(9 / 21 * 100%); /* 21:9 (ultrawide) ratio */
      }

      .embPanel {
        bottom: 0;
        left: 0;
        position: absolute;
        right: 0;
        top: 0;
      }
    `}
`;
const StyledEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  margin-right: 16px;
`;
const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  & .euiAccordion__triggerWrapper {
    padding: 16px;
  }
`;
EmbeddableMap.displayName = 'EmbeddableMap';
const EmbeddedMapComponent = ({
  endDate,
  filters,
  query,
  setQuery,
  startDate
}) => {
  var _storage$get;
  const [embeddable, setEmbeddable] = _react.default.useState(undefined);
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    storage
  } = services;
  const [isError, setIsError] = (0, _react.useState)(false);
  const [isIndexError, setIsIndexError] = (0, _react.useState)(false);
  const [storageValue, setStorageValue] = (0, _react.useState)((_storage$get = storage.get(NETWORK_MAP_VISIBLE)) !== null && _storage$get !== void 0 ? _storage$get : true);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const getDataViewsSelector = (0, _react.useMemo)(() => _sourcerer.sourcererSelectors.getSourcererDataViewsSelector(), []);
  const {
    kibanaDataViews
  } = (0, _use_selector.useDeepEqualSelector)(state => getDataViewsSelector(state));
  const {
    selectedPatterns
  } = (0, _sourcerer2.useSourcererDataView)(_model.SourcererScopeName.default);
  const isFieldInIndexPattern = (0, _fields.useIsFieldInIndexPattern)();
  const [mapDataViews, setMapDataViews] = (0, _react.useState)([]);
  const [availableDataViews, setAvailableDataViews] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    let canceled = false;
    const fetchData = async () => {
      try {
        const apiResponse = await Promise.all(availableDataViews.map(async ({
          title
        }) => isFieldInIndexPattern(title)));
        // ensures only index patterns with maps fields are passed
        const goodDataViews = availableDataViews.filter((_, i) => {
          var _apiResponse$i;
          return (_apiResponse$i = apiResponse[i]) !== null && _apiResponse$i !== void 0 ? _apiResponse$i : false;
        });
        if (!canceled) {
          setMapDataViews(goodDataViews);
        }
      } catch (e) {
        if (!canceled) {
          setMapDataViews([]);
          addError(e, {
            title: i18n.ERROR_CREATING_EMBEDDABLE
          });
          setIsError(true);
        }
      }
    };
    if (availableDataViews.length) {
      fetchData();
    }
    return () => {
      canceled = true;
    };
  }, [addError, availableDataViews, isFieldInIndexPattern]);
  (0, _react.useEffect)(() => {
    const dataViews = kibanaDataViews.filter(dataView => selectedPatterns.includes(dataView.title));
    if (selectedPatterns.length > 0 && dataViews.length === 0) {
      setIsIndexError(true);
    }
    setAvailableDataViews(prevViews => (0, _fp.isEqual)(prevViews, dataViews) ? prevViews : dataViews);
  }, [kibanaDataViews, selectedPatterns]);

  // This portalNode provided by react-reverse-portal allows us re-parent the MapToolTip within our
  // own component tree instead of the embeddables (default). This is necessary to have access to
  // the Redux store, theme provider, etc, which is required to register and un-register the draggable
  // Search InPortal/OutPortal for implementation touch points
  const portalNode = _react.default.useMemo(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);

  // Initial Load useEffect
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    async function setupEmbeddable() {
      // Create & set Embeddable
      try {
        const embeddableObject = await (0, _create_embeddable.createEmbeddable)(filters, mapDataViews, query, startDate, endDate, setQuery, portalNode, services.embeddable);
        if (isSubscribed) {
          setEmbeddable(embeddableObject);
        }
      } catch (e) {
        if (isSubscribed) {
          addError(e, {
            title: i18n.ERROR_CREATING_EMBEDDABLE
          });
          setIsError(true);
        }
      }
    }
    if (embeddable == null && selectedPatterns.length > 0 && !isIndexError) {
      setupEmbeddable();
    }
    return () => {
      isSubscribed = false;
    };
  }, [addError, endDate, embeddable, filters, mapDataViews, query, portalNode, services.embeddable, selectedPatterns, setQuery, startDate, isIndexError]);

  // update layer with new index patterns
  (0, _react.useEffect)(() => {
    const setLayerList = async () => {
      if (embeddable != null && mapDataViews.length) {
        // @ts-expect-error
        await embeddable.setLayerList((0, _map_config.getLayerList)(mapDataViews));
        embeddable.reload();
      }
    };
    if (embeddable != null && !(0, _public.isErrorEmbeddable)(embeddable)) {
      setLayerList();
    }
  }, [embeddable, mapDataViews]);

  // queryExpression updated useEffect
  (0, _react.useEffect)(() => {
    if (embeddable != null) {
      embeddable.updateInput({
        query
      });
    }
  }, [embeddable, query]);
  const timeRangeFilter = (0, _react.useMemo)(() => (0, _helpers.buildTimeRangeFilter)(startDate, endDate), [startDate, endDate]);
  (0, _react.useEffect)(() => {
    if (embeddable != null) {
      // pass time range as filter instead of via timeRange param
      // if user's data view does not have a time field, the timeRange param is not applied
      // using filter will always apply the time range
      embeddable.updateInput({
        filters: [...filters, ...timeRangeFilter]
      });
    }
  }, [embeddable, filters, timeRangeFilter]);
  const setDefaultMapVisibility = (0, _react.useCallback)(isOpen => {
    storage.set(NETWORK_MAP_VISIBLE, isOpen);
    setStorageValue(isOpen);
  }, [storage]);
  const content = (0, _react.useMemo)(() => {
    if (!storageValue) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_embeddable.Embeddable, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
      node: portalNode
    }, /*#__PURE__*/_react.default.createElement(_map_tool_tip.MapToolTip, null)), /*#__PURE__*/_react.default.createElement(EmbeddableMap, {
      maintainRatio: !isIndexError
    }, isIndexError ? /*#__PURE__*/_react.default.createElement(_index_patterns_missing_prompt.IndexPatternsMissingPrompt, {
      "data-test-subj": "missing-prompt"
    }) : embeddable != null ? /*#__PURE__*/_react.default.createElement(_public.EmbeddablePanel, {
      embeddable: embeddable
    }) : /*#__PURE__*/_react.default.createElement(_loader.Loader, {
      "data-test-subj": "loading-panel",
      overlay: true,
      size: "xl"
    })));
  }, [embeddable, isIndexError, portalNode, storageValue]);
  return isError ? null : /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    "data-test-subj": "EmbeddedMapComponent",
    onToggle: setDefaultMapVisibility,
    id: 'network-map',
    arrowDisplay: "right",
    arrowProps: {
      color: 'primary',
      'data-test-subj': `${storageValue}-toggle-network-map`
    },
    buttonContent: /*#__PURE__*/_react.default.createElement("strong", null, i18n.EMBEDDABLE_HEADER_TITLE),
    extraAction: /*#__PURE__*/_react.default.createElement(StyledEuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: `${services.docLinks.links.siem.networkMap}`,
      target: "_blank"
    }, i18n.EMBEDDABLE_HEADER_HELP)),
    paddingSize: "none",
    initialIsOpen: storageValue
  }, content);
};
exports.EmbeddedMapComponent = EmbeddedMapComponent;
EmbeddedMapComponent.displayName = 'EmbeddedMapComponent';
const EmbeddedMap = /*#__PURE__*/_react.default.memo(EmbeddedMapComponent);
exports.EmbeddedMap = EmbeddedMap;
EmbeddedMap.displayName = 'EmbeddedMap';