"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpOverview = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _empty_value = require("../../../../common/components/empty_value");
var _field_renderers = require("../../../../timelines/components/field_renderers/field_renderers");
var _first_last_seen = require("../../../../common/components/first_last_seen/first_last_seen");
var i18n = _interopRequireWildcard(require("./translations"));
var _page = require("../../../../common/components/page");
var _loader = require("../../../../common/components/loader");
var _anomaly_scores = require("../../../../common/components/ml/score/anomaly_scores");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _inspect = require("../../../../common/components/inspect");
var _overview_description_list = require("../../../../common/components/overview_description_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IpOverview = /*#__PURE__*/_react.default.memo(({
  contextID,
  id,
  ip,
  data,
  isDraggable = false,
  isInDetailsSidePanel = false,
  // Rather than duplicate the component, alter the structure based on it's location
  loading,
  flowTarget,
  startDate,
  endDate,
  isLoadingAnomaliesData,
  anomaliesData,
  narrowDateRange,
  indexPatterns,
  jobNameById
}) => {
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const userPermissions = (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities);
  const [darkMode] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_DARK_MODE);
  const typeData = data[flowTarget];
  const column = [{
    title: i18n.LOCATION,
    description: (0, _field_renderers.locationRenderer)([`${flowTarget}.geo.city_name`, `${flowTarget}.geo.region_name`], data, contextID, isDraggable)
  }, {
    title: i18n.AUTONOMOUS_SYSTEM,
    description: typeData ? (0, _field_renderers.autonomousSystemRenderer)(typeData.autonomousSystem, flowTarget, contextID, isDraggable) : (0, _empty_value.getEmptyTagValue)()
  }];
  const firstColumn = userPermissions ? [...column, {
    title: i18n.MAX_ANOMALY_SCORE_BY_JOB,
    description: /*#__PURE__*/_react.default.createElement(_anomaly_scores.AnomalyScores, {
      anomalies: anomaliesData,
      startDate: startDate,
      endDate: endDate,
      isLoading: isLoadingAnomaliesData,
      narrowDateRange: narrowDateRange,
      jobNameById: jobNameById
    })
  }] : column;
  const descriptionLists = [firstColumn, [{
    title: i18n.FIRST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: `${flowTarget}.ip`,
      value: ip,
      type: _first_last_seen.FirstLastSeenType.FIRST_SEEN
    })
  }, {
    title: i18n.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: `${flowTarget}.ip`,
      value: ip,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN
    })
  }], [{
    title: i18n.HOST_ID,
    description: typeData && data.host ? (0, _field_renderers.hostIdRenderer)({
      host: data.host,
      isDraggable,
      ipFilter: ip,
      contextID
    }) : (0, _empty_value.getEmptyTagValue)()
  }, {
    title: i18n.HOST_NAME,
    description: typeData && data.host ? (0, _field_renderers.hostNameRenderer)(data.host, ip, contextID, isDraggable) : (0, _empty_value.getEmptyTagValue)()
  }], [{
    title: i18n.WHOIS,
    description: (0, _field_renderers.whoisRenderer)(ip)
  }, {
    title: i18n.REPUTATION,
    description: (0, _field_renderers.reputationRenderer)(ip)
  }]];
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_page.OverviewWrapper, {
    direction: isInDetailsSidePanel ? 'column' : 'row'
  }, !isInDetailsSidePanel && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: id,
    title: i18n.INSPECT_TITLE,
    inspectIndex: 0
  }), descriptionLists.map((descriptionList, index) => /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    descriptionList: descriptionList,
    key: index
  })), loading && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    overlay: true,
    overlayBackground: darkMode ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor,
    size: "xl"
  })));
});
exports.IpOverview = IpOverview;
IpOverview.displayName = 'IpOverview';