"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsHosts = void 0;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../store/model");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnHostsUrl = tabName => `${_constants.HOSTS_PATH}/${tabName}`;
const navTabsHosts = ({
  hasMlUserPermissions,
  isRiskyHostsEnabled,
  isEnterprise
}) => {
  const hiddenTabs = [];
  const hostsNavTabs = {
    [_model.HostsTableType.hosts]: {
      id: _model.HostsTableType.hosts,
      name: i18n.NAVIGATION_ALL_HOSTS_TITLE,
      href: getTabsOnHostsUrl(_model.HostsTableType.hosts),
      disabled: false
    },
    [_model.HostsTableType.uncommonProcesses]: {
      id: _model.HostsTableType.uncommonProcesses,
      name: i18n.NAVIGATION_UNCOMMON_PROCESSES_TITLE,
      href: getTabsOnHostsUrl(_model.HostsTableType.uncommonProcesses),
      disabled: false
    },
    [_model.HostsTableType.anomalies]: {
      id: _model.HostsTableType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnHostsUrl(_model.HostsTableType.anomalies),
      disabled: false
    },
    [_model.HostsTableType.events]: {
      id: _model.HostsTableType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnHostsUrl(_model.HostsTableType.events),
      disabled: false
    },
    [_model.HostsTableType.risk]: {
      id: _model.HostsTableType.risk,
      name: i18n.NAVIGATION_HOST_RISK_TITLE,
      href: getTabsOnHostsUrl(_model.HostsTableType.risk),
      disabled: false
    },
    [_model.HostsTableType.sessions]: {
      id: _model.HostsTableType.sessions,
      name: i18n.NAVIGATION_SESSIONS_TITLE,
      href: getTabsOnHostsUrl(_model.HostsTableType.sessions),
      disabled: false,
      isBeta: false
    }
  };
  if (!hasMlUserPermissions) {
    hiddenTabs.push(_model.HostsTableType.anomalies);
  }
  if (!isRiskyHostsEnabled) {
    hiddenTabs.push(_model.HostsTableType.risk);
  }
  if (!isEnterprise) {
    hiddenTabs.push(_model.HostsTableType.sessions);
  }
  return (0, _fp.omit)(hiddenTabs, hostsNavTabs);
};
exports.navTabsHosts = navTabsHosts;