"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsMapping = exports.HostsKpiUniqueIps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kpi_unique_ips_area = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_area");
var _kpi_unique_ips_bar = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_bar");
var _kpi_unique_ips_destination_metric = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_destination_metric");
var _kpi_unique_ips_source_metric = require("../../../../../common/components/visualization_actions/lens_attributes/hosts/kpi_unique_ips_source_metric");
var _unique_ips = require("../../../containers/kpi_hosts/unique_ips");
var _common = require("../common");
var _types = require("../types");
var i18n = _interopRequireWildcard(require("./translations"));
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _constants = require("../../../../../common/store/inputs/constants");
var _use_refetch_by_session = require("../../../../../common/components/page/use_refetch_by_session");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldsMapping = [{
  key: 'uniqueIps',
  fields: [{
    key: 'uniqueSourceIps',
    name: i18n.SOURCE_CHART_LABEL,
    description: i18n.SOURCE_UNIT_LABEL,
    value: null,
    color: _types.HostsKpiChartColors.uniqueSourceIps,
    icon: 'visMapCoordinate',
    lensAttributes: _kpi_unique_ips_source_metric.kpiUniqueIpsSourceMetricLensAttributes
  }, {
    key: 'uniqueDestinationIps',
    name: i18n.DESTINATION_CHART_LABEL,
    description: i18n.DESTINATION_UNIT_LABEL,
    value: null,
    color: _types.HostsKpiChartColors.uniqueDestinationIps,
    icon: 'visMapCoordinate',
    lensAttributes: _kpi_unique_ips_destination_metric.kpiUniqueIpsDestinationMetricLensAttributes
  }],
  enableAreaChart: true,
  enableBarChart: true,
  description: i18n.UNIQUE_IPS,
  areaChartLensAttributes: _kpi_unique_ips_area.kpiUniqueIpsAreaLensAttributes,
  barChartLensAttributes: _kpi_unique_ips_bar.kpiUniqueIpsBarLensAttributes
}];
exports.fieldsMapping = fieldsMapping;
const HostsKpiUniqueIpsComponent = ({
  filterQuery,
  from,
  indexNames,
  to,
  updateDateRange,
  setQuery,
  skip
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_unique_ips.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    refetch,
    id,
    inspect,
    ...data
  }] = (0, _unique_ips.useHostsKpiUniqueIps)({
    filterQuery,
    endDate: to,
    indexNames,
    startDate: from,
    skip: querySkip || isChartEmbeddablesEnabled
  });
  const {
    session,
    refetchByRestartingSession
  } = (0, _use_refetch_by_session.useRefetchByRestartingSession)({
    inputId: _constants.InputsModelId.global,
    queryId: id
  });
  return /*#__PURE__*/_react.default.createElement(_common.KpiBaseComponentManage, {
    data: data,
    id: id,
    inspect: inspect,
    loading: loading,
    fieldsMapping: fieldsMapping,
    from: from,
    to: to,
    updateDateRange: updateDateRange,
    refetch: isChartEmbeddablesEnabled ? refetchByRestartingSession : refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    session: isChartEmbeddablesEnabled ? session : undefined
  });
};
const HostsKpiUniqueIps = /*#__PURE__*/_react.default.memo(HostsKpiUniqueIpsComponent);
exports.HostsKpiUniqueIps = HostsKpiUniqueIps;