"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToggleStatus = void 0;
var _react = require("react");
var _query_toggle = require("../../../common/containers/query_toggle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToggleStatus = ({
  id,
  setQuerySkip
}) => {
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(id);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
    // toggleStatus on = skipQuery false
    setQuerySkip(!status);
  }, [setQuerySkip, setToggleStatus]);
  const onToggle = (0, _react.useCallback)(() => toggleQuery(!toggleStatus), [toggleQuery, toggleStatus]);
  return {
    isToggleExpanded: toggleStatus,
    onToggle
  };
};
exports.useToggleStatus = useToggleStatus;