"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKpiMatrixStatus = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKpiMatrixStatus = (mappings, data, id, from, to, updateDateRange, setQuerySkip, loading) => mappings.map(stat => ({
  ...stat,
  areaChart: stat.enableAreaChart ? (0, _utils.addValueToAreaChart)(stat.fields, data) : undefined,
  barChart: stat.enableBarChart ? (0, _utils.addValueToBarChart)(stat.fields, data) : undefined,
  fields: (0, _utils.addValueToFields)(stat.fields, data),
  id,
  key: `kpi-summary-${stat.key}`,
  statKey: `${stat.key}`,
  from,
  to,
  updateDateRange,
  setQuerySkip,
  loading
}));
exports.useKpiMatrixStatus = useKpiMatrixStatus;