"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatItemHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("../../../common/containers/query_toggle/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatItemHeaderComponent = ({
  onToggle,
  isToggleExpanded,
  description
}) => /*#__PURE__*/_react.default.createElement(_utils.FlexGroup, {
  gutterSize: 'none'
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  className: isToggleExpanded ? '' : 'no-margin'
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: 'none',
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  "aria-label": i18n.QUERY_BUTTON_TITLE(isToggleExpanded),
  "data-test-subj": "query-toggle-stat",
  color: "text",
  display: "empty",
  iconType: isToggleExpanded ? 'arrowDown' : 'arrowRight',
  onClick: onToggle,
  size: "xs",
  title: i18n.QUERY_BUTTON_TITLE(isToggleExpanded)
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxxs"
}, /*#__PURE__*/_react.default.createElement(_utils.StyledTitle, null, description))))));
const StatItemHeader = /*#__PURE__*/_react.default.memo(StatItemHeaderComponent);
exports.StatItemHeader = StatItemHeader;
StatItemHeader.displayName = 'StatItemHeader';