"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreLevel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
var _utils = require("../../../../../entity_analytics/common/utils");
var _with_hover_actions = require("../../../../../common/components/with_hover_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskBadge = _styledComponents.default.div`
  ${({
  theme,
  $severity,
  $hideBackgroundColor
}) => (0, _styledComponents.css)`
    width: fit-content;
    padding-right: ${theme.eui.euiSizeS};
    padding-left: ${theme.eui.euiSizeXS};

    ${($severity === 'Critical' || $severity === 'High') && !$hideBackgroundColor && (0, _styledComponents.css)`
      background-color: ${(0, _eui.transparentize)(theme.eui.euiColorDanger, 0.2)};
      border-radius: 999px; // pill shaped
    `};
  `}
`;
const TooltipContainer = _styledComponents.default.div`
  padding: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const RiskScoreLevel = ({
  severity,
  hideBackgroundColor = false,
  toolTipContent
}) => {
  const badge = /*#__PURE__*/_react.default.createElement(RiskBadge, {
    color: _uiTheme.euiLightVars.euiColorDanger,
    $severity: severity,
    $hideBackgroundColor: hideBackgroundColor,
    "data-test-subj": "risk-score"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    className: "eui-alignMiddle",
    color: _utils.RISK_SEVERITY_COLOUR[severity]
  }, severity));
  if (toolTipContent != null) {
    return /*#__PURE__*/_react.default.createElement(_with_hover_actions.WithHoverActions, {
      hoverContent: /*#__PURE__*/_react.default.createElement(TooltipContainer, null, toolTipContent),
      render: () => badge
    });
  }
  return badge;
};
exports.RiskScoreLevel = RiskScoreLevel;