"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upgradeUserRiskScoreModule = exports.upgradeHostRiskScoreModule = exports.uninstallRiskScoreModule = exports.restartRiskScoreTransforms = exports.installRiskScoreModule = void 0;
var _search_strategy = require("../../../../../common/search_strategy");
var utils = _interopRequireWildcard(require("../../../../../common/utils/risk_score_modules"));
var _api = require("../../../containers/risk_score/onboarding/api");
var _translations = require("../../../containers/risk_score/onboarding/api/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const installHostRiskScoreModule = async ({
  dashboard,
  http,
  notifications,
  refetch,
  renderDashboardLink,
  renderDocLink,
  theme,
  timerange
}) => {
  await (0, _api.installRiskScore)({
    http,
    renderDocLink,
    notifications,
    options: {
      riskScoreEntity: _search_strategy.RiskScoreEntity.host
    }
  });

  // Install dashboards and relevant saved objects
  await (0, _api.bulkCreatePrebuiltSavedObjects)({
    http,
    theme,
    dashboard,
    renderDashboardLink,
    renderDocLink,
    ...timerange,
    notifications,
    options: {
      templateName: `${_search_strategy.RiskScoreEntity.host}RiskScoreDashboards`
    }
  });
  if (refetch) {
    refetch();
  }
};
const installUserRiskScoreModule = async ({
  dashboard,
  http,
  notifications,
  refetch,
  renderDashboardLink,
  renderDocLink,
  spaceId = 'default',
  theme,
  timerange
}) => {
  await (0, _api.installRiskScore)({
    http,
    renderDocLink,
    notifications,
    options: {
      riskScoreEntity: _search_strategy.RiskScoreEntity.user
    }
  });

  // Install dashboards and relevant saved objects
  await (0, _api.bulkCreatePrebuiltSavedObjects)({
    dashboard,
    http,
    notifications,
    options: {
      templateName: `${_search_strategy.RiskScoreEntity.user}RiskScoreDashboards`
    },
    renderDashboardLink,
    renderDocLink,
    ...timerange,
    theme
  });
  if (refetch) {
    refetch();
  }
};
const installRiskScoreModule = async settings => {
  if (settings.riskScoreEntity === _search_strategy.RiskScoreEntity.user) {
    await installUserRiskScoreModule(settings);
  } else {
    await installHostRiskScoreModule(settings);
  }
};
exports.installRiskScoreModule = installRiskScoreModule;
const uninstallRiskScoreModule = async ({
  http,
  notifications,
  refetch,
  renderDocLink,
  riskScoreEntity,
  spaceId = 'default',
  theme
}) => {
  const legacyTransformIds = [
  // transform Ids never changed since 8.3
  utils.getRiskScorePivotTransformId(riskScoreEntity, spaceId), utils.getRiskScoreLatestTransformId(riskScoreEntity, spaceId)];
  const legacyRiskScoreHostsScriptIds = [
  // 8.4
  utils.getLegacyRiskScoreLevelScriptId(_search_strategy.RiskScoreEntity.host), utils.getLegacyRiskScoreInitScriptId(_search_strategy.RiskScoreEntity.host), utils.getLegacyRiskScoreMapScriptId(_search_strategy.RiskScoreEntity.host), utils.getLegacyRiskScoreReduceScriptId(_search_strategy.RiskScoreEntity.host),
  // 8.3 and after 8.5
  utils.getRiskScoreLevelScriptId(_search_strategy.RiskScoreEntity.host, spaceId), utils.getRiskScoreInitScriptId(_search_strategy.RiskScoreEntity.host, spaceId), utils.getRiskScoreMapScriptId(_search_strategy.RiskScoreEntity.host, spaceId), utils.getRiskScoreReduceScriptId(_search_strategy.RiskScoreEntity.host, spaceId)];
  const legacyRiskScoreUsersScriptIds = [
  // 8.4
  utils.getLegacyRiskScoreLevelScriptId(_search_strategy.RiskScoreEntity.user), utils.getLegacyRiskScoreMapScriptId(_search_strategy.RiskScoreEntity.user), utils.getLegacyRiskScoreReduceScriptId(_search_strategy.RiskScoreEntity.user),
  // 8.3 and after 8.5
  utils.getRiskScoreLevelScriptId(_search_strategy.RiskScoreEntity.user, spaceId), utils.getRiskScoreMapScriptId(_search_strategy.RiskScoreEntity.user, spaceId), utils.getRiskScoreReduceScriptId(_search_strategy.RiskScoreEntity.user, spaceId)];
  const legacyIngestPipelineNames = [
  // 8.4
  utils.getLegacyIngestPipelineName(riskScoreEntity),
  // 8.3 and 8.5
  utils.getIngestPipelineName(riskScoreEntity, spaceId)];
  await Promise.all([
  /**
   * Intended not to pass notification to bulkDeletePrebuiltSavedObjects.
   * As the only error it can happen is saved object not found, and
   * that is what bulkDeletePrebuiltSavedObjects wants.
   * (Before 8.5 once an saved object was created, it was shared across different spaces.
   * If it has been upgrade in one space, "saved object not found" will happen when upgrading other spaces.
   * Or it could be users manually deleted the saved object.)
   */
  (0, _api.bulkDeletePrebuiltSavedObjects)({
    http,
    options: {
      templateName: `${riskScoreEntity}RiskScoreDashboards`
    }
  }), (0, _api.deleteTransforms)({
    http,
    theme,
    renderDocLink,
    notifications,
    errorMessage: `${_translations.UNINSTALLATION_ERROR} - ${(0, _translations.TRANSFORM_DELETION_ERROR_MESSAGE)(legacyTransformIds.length)}`,
    transformIds: legacyTransformIds,
    options: {
      deleteDestIndex: true,
      deleteDestDataView: true,
      forceDelete: false
    }
  }),
  /**
   * Intended not to pass notification to deleteIngestPipelines.
   * As the only error it can happen is ingest pipeline not found, and
   * that is what deleteIngestPipelines wants.
   * (Before 8.5 once an ingest pipeline was created, it was shared across different spaces.
   * If it has been upgrade in one space, "ingest pipeline not found" will happen when upgrading other spaces.
   * Or it could be users manually deleted the ingest pipeline.)
   */
  (0, _api.deleteIngestPipelines)({
    http,
    errorMessage: `${_translations.UNINSTALLATION_ERROR} - ${(0, _translations.INGEST_PIPELINE_DELETION_ERROR_MESSAGE)(legacyIngestPipelineNames.length)}`,
    names: legacyIngestPipelineNames.join(',')
  }),
  /**
   * Intended not to pass notification to deleteStoredScripts.
   * As the only error it can happen is script not found, and
   * that is what deleteStoredScripts wants.
   * (In 8.4 once a script was created, it was shared across different spaces.
   * If it has been upgrade in one space, "script not found" will happen when upgrading other spaces.
   * Or it could be users manually deleted the script.)
   */
  (0, _api.deleteStoredScripts)({
    http,
    ids: riskScoreEntity === _search_strategy.RiskScoreEntity.user ? legacyRiskScoreUsersScriptIds : legacyRiskScoreHostsScriptIds
  })]);
  if (refetch) {
    refetch();
  }
};
exports.uninstallRiskScoreModule = uninstallRiskScoreModule;
const upgradeHostRiskScoreModule = async ({
  dashboard,
  http,
  notifications,
  refetch,
  renderDashboardLink,
  renderDocLink,
  spaceId = 'default',
  theme,
  timerange
}) => {
  await uninstallRiskScoreModule({
    http,
    notifications,
    renderDocLink,
    riskScoreEntity: _search_strategy.RiskScoreEntity.host,
    spaceId,
    theme
  });
  await installRiskScoreModule({
    dashboard,
    http,
    notifications,
    refetch,
    renderDashboardLink,
    renderDocLink,
    riskScoreEntity: _search_strategy.RiskScoreEntity.host,
    spaceId,
    theme,
    timerange
  });
};
exports.upgradeHostRiskScoreModule = upgradeHostRiskScoreModule;
const upgradeUserRiskScoreModule = async ({
  dashboard,
  http,
  notifications,
  refetch,
  renderDashboardLink,
  renderDocLink,
  spaceId = 'default',
  theme,
  timerange
}) => {
  await uninstallRiskScoreModule({
    http,
    notifications,
    renderDocLink,
    riskScoreEntity: _search_strategy.RiskScoreEntity.user,
    spaceId,
    theme
  });
  await installRiskScoreModule({
    dashboard,
    http,
    notifications,
    refetch,
    renderDashboardLink,
    renderDocLink,
    riskScoreEntity: _search_strategy.RiskScoreEntity.user,
    spaceId,
    theme,
    timerange
  });
};
exports.upgradeUserRiskScoreModule = upgradeUserRiskScoreModule;
const restartRiskScoreTransforms = async ({
  http,
  notifications,
  refetch,
  renderDocLink,
  riskScoreEntity,
  spaceId
}) => {
  const transformIds = [utils.getRiskScorePivotTransformId(riskScoreEntity, spaceId), utils.getRiskScoreLatestTransformId(riskScoreEntity, spaceId)];
  await (0, _api.stopTransforms)({
    http,
    notifications,
    renderDocLink,
    transformIds
  });
  const res = await (0, _api.startTransforms)({
    http,
    notifications,
    renderDocLink,
    transformIds
  });
  if (refetch) {
    refetch();
  }
  return res;
};
exports.restartRiskScoreTransforms = restartRiskScoreTransforms;