"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useImportExceptionList = exports.importExceptionList = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const importExceptionList = async ({
  file,
  http,
  signal,
  overwrite,
  overwriteExceptions,
  asNewList
}) => {
  const formData = new FormData();
  formData.append('file', file);
  const res = await http.post(`${_securitysolutionListConstants.EXCEPTION_LIST_URL}/_import`, {
    body: formData,
    query: {
      overwrite,
      overwrite_exceptions: overwriteExceptions,
      as_new_list: asNewList
    },
    headers: {
      'Content-Type': undefined
    },
    method: 'POST',
    signal
  });
  return res;
};
exports.importExceptionList = importExceptionList;
const importListWithOptionalSignal = (0, _securitysolutionHookUtils.withOptionalSignal)(importExceptionList);
const useImportExceptionList = () => (0, _securitysolutionHookUtils.useAsync)(importListWithOptionalSignal);
exports.useImportExceptionList = useImportExceptionList;