"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initRiskEngine = exports.fetchRiskScorePreview = exports.fetchRiskEngineStatus = exports.fetchRiskEnginePrivileges = exports.fetchAssetCriticalityPrivileges = exports.enableRiskEngine = exports.disableRiskEngine = void 0;
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Fetches preview risks scores
 */
const fetchRiskScorePreview = async ({
  signal,
  params
}) => {
  return _kibana.KibanaServices.get().http.fetch(_constants.RISK_SCORE_PREVIEW_URL, {
    version: '1',
    method: 'POST',
    body: JSON.stringify(params),
    signal
  });
};

/**
 * Fetches risks engine status
 */
exports.fetchRiskScorePreview = fetchRiskScorePreview;
const fetchRiskEngineStatus = async ({
  signal
}) => {
  return _kibana.KibanaServices.get().http.fetch(_constants.RISK_ENGINE_STATUS_URL, {
    version: '1',
    method: 'GET',
    signal
  });
};

/**
 * Init risk score engine
 */
exports.fetchRiskEngineStatus = fetchRiskEngineStatus;
const initRiskEngine = async () => {
  return _kibana.KibanaServices.get().http.fetch(_constants.RISK_ENGINE_INIT_URL, {
    version: '1',
    method: 'POST'
  });
};

/**
 * Enable risk score engine
 */
exports.initRiskEngine = initRiskEngine;
const enableRiskEngine = async () => {
  return _kibana.KibanaServices.get().http.fetch(_constants.RISK_ENGINE_ENABLE_URL, {
    version: '1',
    method: 'POST'
  });
};

/**
 * Disable risk score engine
 */
exports.enableRiskEngine = enableRiskEngine;
const disableRiskEngine = async () => {
  return _kibana.KibanaServices.get().http.fetch(_constants.RISK_ENGINE_DISABLE_URL, {
    version: '1',
    method: 'POST'
  });
};

/**
 * Get risk engine privileges
 */
exports.disableRiskEngine = disableRiskEngine;
const fetchRiskEnginePrivileges = async () => {
  return _kibana.KibanaServices.get().http.fetch(_constants.RISK_ENGINE_PRIVILEGES_URL, {
    version: '1',
    method: 'GET'
  });
};

/**
 * Get asset criticality privileges
 */
exports.fetchRiskEnginePrivileges = fetchRiskEnginePrivileges;
const fetchAssetCriticalityPrivileges = async () => {
  return _kibana.KibanaServices.get().http.fetch(_constants.ASSET_CRITICALITY_PRIVILEGES_URL, {
    version: '1',
    method: 'GET'
  });
};
exports.fetchAssetCriticalityPrivileges = fetchAssetCriticalityPrivileges;