"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_UNAUTHENTICATED_TITLE = exports.USER_UNAUTHENTICATED_MSG_BODY = exports.PAGE_TITLE = exports.NO_INDEX_TITLE = exports.NEEDS_SIGNALS_INDEX = exports.NEEDS_SIGNALS_AND_LISTS_INDEXES = exports.NEEDS_LISTS_INDEXES = exports.NEEDS_INDEX_PERMISSIONS = exports.ML_RULES_UNAVAILABLE = exports.ML_RULES_DISABLED_MESSAGE = exports.GO_TO_DOCUMENTATION = exports.BUTTON_MANAGE_RULES = exports.ALERT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.detectionsPageTitle', {
  defaultMessage: 'Alerts'
});
exports.PAGE_TITLE = PAGE_TITLE;
const ALERT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alertTitle', {
  defaultMessage: 'Alerts'
});
exports.ALERT = ALERT;
const BUTTON_MANAGE_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.buttonManageRules', {
  defaultMessage: 'Manage rules'
});
exports.BUTTON_MANAGE_RULES = BUTTON_MANAGE_RULES;
const NO_INDEX_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.noIndexTitle', {
  defaultMessage: 'Let’s set up your detection engine'
});
exports.NO_INDEX_TITLE = NO_INDEX_TITLE;
const NEEDS_SIGNALS_AND_LISTS_INDEXES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsSignalsAndListsIndexesMessage', {
  defaultMessage: 'You need permissions for the signals and lists indices.'
});
exports.NEEDS_SIGNALS_AND_LISTS_INDEXES = NEEDS_SIGNALS_AND_LISTS_INDEXES;
const NEEDS_SIGNALS_INDEX = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsSignalsIndexMessage', {
  defaultMessage: 'You need permissions for the signals index.'
});
exports.NEEDS_SIGNALS_INDEX = NEEDS_SIGNALS_INDEX;
const NEEDS_LISTS_INDEXES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsListsIndexesMessage', {
  defaultMessage: 'You need permissions for the lists indices.'
});
exports.NEEDS_LISTS_INDEXES = NEEDS_LISTS_INDEXES;
const NEEDS_INDEX_PERMISSIONS = additionalContext => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.needsIndexPermissionsMessage', {
  values: {
    additionalContext
  },
  defaultMessage: 'To use the detection engine, a user with the required cluster and index privileges must first access this page. {additionalContext} For more help, contact your Elastic Stack administrator.'
});
exports.NEEDS_INDEX_PERMISSIONS = NEEDS_INDEX_PERMISSIONS;
const GO_TO_DOCUMENTATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.goToDocumentationButton', {
  defaultMessage: 'View documentation'
});
exports.GO_TO_DOCUMENTATION = GO_TO_DOCUMENTATION;
const USER_UNAUTHENTICATED_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.userUnauthenticatedTitle', {
  defaultMessage: 'Detection engine permissions required'
});
exports.USER_UNAUTHENTICATED_TITLE = USER_UNAUTHENTICATED_TITLE;
const USER_UNAUTHENTICATED_MSG_BODY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.userUnauthenticatedMsgBody', {
  defaultMessage: 'You do not have the required permissions for viewing the detection engine. For more help, contact your administrator.'
});
exports.USER_UNAUTHENTICATED_MSG_BODY = USER_UNAUTHENTICATED_MSG_BODY;
const ML_RULES_DISABLED_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlRulesDisabledMessageTitle', {
  defaultMessage: 'ML rules require Platinum License and ML Admin Permissions'
});
exports.ML_RULES_DISABLED_MESSAGE = ML_RULES_DISABLED_MESSAGE;
const ML_RULES_UNAVAILABLE = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlUnavailableTitle', {
  values: {
    totalRules
  },
  defaultMessage: '{totalRules} {totalRules, plural, =1 {rule requires} other {rules require}} Machine Learning to enable.'
});
exports.ML_RULES_UNAVAILABLE = ML_RULES_UNAVAILABLE;