"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsRedirect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _moment = _interopRequireDefault(require("moment"));
var _rison = require("@kbn/rison");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _use_url_state = require("../../../common/hooks/use_url_state");
var _store = require("../../../common/store");
var _format_page_filter_search_param = require("../../../../common/utils/format_page_filter_search_param");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertDetailsRedirect = () => {
  var _searchParams$get;
  const {
    alertId
  } = (0, _reactRouterDom.useParams)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const searchParams = new URLSearchParams(search);
  const timestamp = searchParams.get('timestamp');
  // Although we use the 'default' space here when an index isn't provided or accidentally deleted
  // It's a safe catch all as we reset the '.internal.alerts-*` indices with the correct space in the flyout
  // Here: x-pack/plugins/security_solution/public/timelines/components/side_panel/event_details/helpers.tsx
  const index = (_searchParams$get = searchParams.get('index')) !== null && _searchParams$get !== void 0 ? _searchParams$get : `.internal${_constants.DEFAULT_ALERTS_INDEX}-default`;
  const getInputSelector = (0, _react.useMemo)(() => _store.inputsSelectors.inputsSelector(), []);
  const inputState = (0, _reactRedux.useSelector)(getInputSelector);
  const {
    linkTo: globalLinkTo,
    timerange: globalTimerange
  } = inputState.global;
  const {
    linkTo: timelineLinkTo,
    timerange: timelineTimerange
  } = inputState.timeline;

  // Default to the existing global timerange if we don't get this query param for whatever reason
  const fromTime = timestamp !== null && timestamp !== void 0 ? timestamp : globalTimerange.from;
  // Add 5 minutes to the alert timestamp as the alert table is non-inclusive of the end time
  // This also provides padding time if the user clears the `_id` filter after redirect to see other alerts
  const toTime = (0, _moment.default)(timestamp !== null && timestamp !== void 0 ? timestamp : globalTimerange.to).add('5', 'minutes');
  const timerange = (0, _rison.encode)({
    global: {
      [_use_url_state.URL_PARAM_KEY.timerange]: {
        kind: 'absolute',
        from: fromTime,
        to: toTime
      },
      linkTo: globalLinkTo
    },
    timeline: {
      [_use_url_state.URL_PARAM_KEY.timerange]: timelineTimerange,
      linkTo: timelineLinkTo
    }
  });
  const kqlAppQuery = (0, _rison.encode)({
    language: 'kuery',
    query: `_id: ${alertId}`
  });
  const statusPageFilter = {
    fieldName: _ruleDataUtils.ALERT_WORKFLOW_STATUS,
    title: 'Status',
    selectedOptions: [],
    existsSelected: false
  };
  const pageFiltersQuery = (0, _rison.encode)((0, _format_page_filter_search_param.formatPageFilterSearchParam)([statusPageFilter]));
  const currentFlyoutParams = searchParams.get(_use_url_state.URL_PARAM_KEY.eventFlyout);
  const [isSecurityFlyoutEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_EXPANDABLE_FLYOUT_SETTING);
  const urlParams = new URLSearchParams({
    [_use_url_state.URL_PARAM_KEY.appQuery]: kqlAppQuery,
    [_use_url_state.URL_PARAM_KEY.timerange]: timerange,
    [_use_url_state.URL_PARAM_KEY.pageFilter]: pageFiltersQuery,
    [_use_url_state.URL_PARAM_KEY.eventFlyout]: (0, _utils.resolveFlyoutParams)({
      index,
      alertId,
      isSecurityFlyoutEnabled
    }, currentFlyoutParams)
  });
  const url = `${_constants.ALERTS_PATH}?${urlParams.toString()}`;
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: url
  });
};
exports.AlertDetailsRedirect = AlertDetailsRedirect;