"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const links = {
  id: _constants.SecurityPageName.alerts,
  title: _translations.ALERTS,
  path: _constants.ALERTS_PATH,
  capabilities: [`${_constants.SERVER_APP_ID}.show`],
  globalNavPosition: 3,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.alerts', {
    defaultMessage: 'Alerts'
  })]
};
exports.links = links;