"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseCellActionsHook = void 0;
var _react = require("react");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _cell_actions = require("../../../common/components/cell_actions");
var _constants = require("../../../actions/constants");
var _constants2 = require("../../../../common/constants");
var _model = require("../../../common/store/sourcerer/model");
var _use_selector = require("../../../common/hooks/use_selector");
var _use_get_field_spec = require("../../../common/hooks/use_get_field_spec");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUseCellActionsHook = tableId => {
  const useCellActions = ({
    columns,
    data,
    dataGridRef
  }) => {
    var _useShallowEqualSelec;
    const getFieldSpec = (0, _use_get_field_spec.useGetFieldSpec)(_model.SourcererScopeName.detections);
    /**
     * There is difference between how `triggers actions` fetched data v/s
     * how security solution fetches data via timelineSearchStrategy
     *
     * _id and _index fields are array in timelineSearchStrategy  but not in
     * ruleStrategy
     *
     *
     */

    const finalData = (0, _react.useMemo)(() => data.map(row => row.map(field => {
      let localField = field;
      if (['_id', '_index'].includes(field.field)) {
        var _field$value;
        const newValue = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '';
        localField = {
          field: field.field,
          value: Array.isArray(newValue) ? newValue : [newValue]
        };
      }
      return localField;
    })), [data]);
    const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
    const viewMode = (_useShallowEqualSelec = (0, _use_selector.useShallowEqualSelector)(state => {
      var _getTable;
      return ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode;
    })) !== null && _useShallowEqualSelec !== void 0 ? _useShallowEqualSelec : _securitysolutionDataTable.tableDefaults.viewMode;
    const cellActionsMetadata = (0, _react.useMemo)(() => ({
      scopeId: tableId
    }), []);
    const cellActionsFields = (0, _react.useMemo)(() => {
      if (viewMode === _constants2.VIEW_SELECTION.eventRenderedView) {
        return undefined;
      }
      return columns.map(column => {
        var _getFieldSpec;
        return (_getFieldSpec = getFieldSpec(column.id)) !== null && _getFieldSpec !== void 0 ? _getFieldSpec : {
          name: '',
          type: '',
          // When type is an empty string all cell actions are incompatible
          aggregatable: false,
          searchable: false
        };
      });
    }, [getFieldSpec, columns, viewMode]);
    const getCellValue = (0, _react.useCallback)((fieldName, rowIndex) => {
      var _finalData$pageRowInd, _finalData$pageRowInd2;
      const pageRowIndex = rowIndex % finalData.length;
      return (_finalData$pageRowInd = (_finalData$pageRowInd2 = finalData[pageRowIndex].find(rowData => rowData.field === fieldName)) === null || _finalData$pageRowInd2 === void 0 ? void 0 : _finalData$pageRowInd2.value) !== null && _finalData$pageRowInd !== void 0 ? _finalData$pageRowInd : [];
    }, [finalData]);
    const disabledActionTypes = tableId === _securitysolutionDataTable.TableId.alertsOnCasePage ? [_constants.SecurityCellActionType.FILTER] : undefined;
    const cellActions = (0, _cell_actions.useDataGridColumnsSecurityCellActions)({
      triggerId: _constants.SecurityCellActionsTrigger.DEFAULT,
      fields: cellActionsFields,
      getCellValue,
      metadata: cellActionsMetadata,
      dataGridRef,
      disabledActionTypes
    });
    const getCellActions = (0, _react.useCallback)((_columnId, columnIndex) => {
      if (cellActions.length === 0) return [];
      return cellActions[columnIndex];
    }, [cellActions]);
    return {
      getCellActions,
      visibleCellActions: 3
    };
  };
  return useCellActions;
};
exports.getUseCellActionsHook = getUseCellActionsHook;