"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertHistogramCount = void 0;
var _react = require("react");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("../../components/alerts_kpis/alerts_histogram_panel/translations");
var _use_visualization_response = require("../../../common/components/visualization_actions/use_visualization_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertHistogramCount = ({
  totalAlertsObj,
  visualizationId,
  isChartEmbeddablesEnabled
}) => {
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const visualizationResponse = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId
  });
  const totalAlerts = (0, _react.useMemo)(() => (0, _translations.SHOWING_ALERTS)((0, _numeral.default)(totalAlertsObj.value).format(defaultNumberFormat), totalAlertsObj.value, totalAlertsObj.relation === 'gte' ? '>' : totalAlertsObj.relation === 'lte' ? '<' : ''), [totalAlertsObj.value, totalAlertsObj.relation, defaultNumberFormat]);
  const visualizationAlerts = (0, _react.useMemo)(() => {
    const visualizationAlertsCount = visualizationResponse != null ? visualizationResponse[0].hits.total : 0;
    return (0, _translations.SHOWING_ALERTS)((0, _numeral.default)(visualizationAlertsCount).format(defaultNumberFormat), visualizationAlertsCount, '');
  }, [defaultNumberFormat, visualizationResponse]);
  return isChartEmbeddablesEnabled ? visualizationAlerts : totalAlerts;
};
exports.useAlertHistogramCount = useAlertHistogramCount;