"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListsIndex = void 0;
var _react = require("react");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_lists_privileges = require("./use_lists_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useListsIndex = () => {
  const [indexExists, setIndexExists] = (0, _react.useState)(null);
  const [error, setError] = (0, _react.useState)(null);
  const {
    lists
  } = (0, _kibana.useKibana)().services;
  const http = (0, _kibana.useHttp)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    canReadIndex,
    canManageIndex,
    canWriteIndex
  } = (0, _use_lists_privileges.useListsPrivileges)();
  const {
    loading: readLoading,
    start: readListIndex,
    ...readListIndexState
  } = (0, _securitysolutionListHooks.useReadListIndex)();
  const {
    loading: createLoading,
    start: createListIndex,
    ...createListIndexState
  } = (0, _securitysolutionListHooks.useCreateListIndex)();
  const loading = readLoading || createLoading;

  // read route utilizes `esClient.indices.getAlias` which requires
  // management privileges
  const readIndex = (0, _react.useCallback)(() => {
    if (lists && canReadIndex && canManageIndex) {
      readListIndex({
        http
      });
    }
  }, [http, lists, readListIndex, canReadIndex, canManageIndex]);
  const createIndex = (0, _react.useCallback)(() => {
    if (lists && canManageIndex && canWriteIndex) {
      createListIndex({
        http
      });
    }
  }, [createListIndex, http, lists, canManageIndex, canWriteIndex]);

  // initial read list
  (0, _react.useEffect)(() => {
    if (!readLoading && !error && indexExists === null) {
      readIndex();
    }
  }, [error, indexExists, readIndex, readLoading]);

  // handle read result
  (0, _react.useEffect)(() => {
    if (readListIndexState.result != null) {
      setIndexExists(readListIndexState.result.list_index && readListIndexState.result.list_item_index);
    }
  }, [readListIndexState.result]);

  // refetch index after creation
  (0, _react.useEffect)(() => {
    if (createListIndexState.result != null) {
      readIndex();
    }
  }, [createListIndexState.result, readIndex]);

  // handle read error
  (0, _react.useEffect)(() => {
    const err = readListIndexState.error;
    if (err != null) {
      if ((0, _securitysolutionTGrid.isSecurityAppError)(err) && err.body.status_code === 404) {
        setIndexExists(false);
      } else {
        setError(err);
        addError(err, {
          title: i18n.LISTS_INDEX_FETCH_FAILURE
        });
      }
    }
  }, [addError, readListIndexState.error]);

  // handle create error
  (0, _react.useEffect)(() => {
    const err = createListIndexState.error;
    if (err != null) {
      setError(err);
      addError(err, {
        title: i18n.LISTS_INDEX_CREATE_FAILURE
      });
    }
  }, [addError, createListIndexState.error]);
  return {
    createIndex,
    error,
    indexExists,
    loading
  };
};
exports.useListsIndex = useListsIndex;