"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columns = void 0;
var _default_headers = require("../../../../timelines/components/timeline/body/column_headers/default_headers");
var _constants = require("../../../../timelines/components/timeline/body/constants");
var i18n = _interopRequireWildcard(require("../../../components/alerts_table/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * columns implements a subset of `EuiDataGrid`'s `EuiDataGridColumn` interface,
 * plus additional TGrid column properties
 */
const columns = [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: '@timestamp',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH + 5
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'kibana.alert.rule.name',
  displayAsText: i18n.ALERTS_HEADERS_RULE_NAME,
  linkField: 'kibana.alert.rule.uuid',
  initialWidth: 212
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'kibana.alert.severity',
  displayAsText: i18n.ALERTS_HEADERS_SEVERITY,
  initialWidth: 104
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  id: 'kibana.alert.reason',
  displayAsText: i18n.ALERTS_HEADERS_REASON
}];
exports.columns = columns;