"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchPrivileges = exports.useFetchDetectionEnginePrivileges = void 0;
var _react = require("react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _api = require("../../containers/detection_engine/alerts/api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchPrivileges = () => (0, _securitysolutionHookUtils.useAsync)((0, _securitysolutionHookUtils.withOptionalSignal)(_api.getUserPrivilege));
exports.useFetchPrivileges = useFetchPrivileges;
const useFetchDetectionEnginePrivileges = (isAppAvailable = true) => {
  const {
    start,
    ...detectionEnginePrivileges
  } = useFetchPrivileges();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    const {
      loading,
      result,
      error
    } = detectionEnginePrivileges;
    if (isAppAvailable && !loading && !(result || error)) {
      abortCtrlRef.current.abort();
      abortCtrlRef.current = new AbortController();
      start({
        signal: abortCtrlRef.current.signal
      });
    }
  }, [start, detectionEnginePrivileges, isAppAvailable]);
  (0, _react.useEffect)(() => {
    return () => {
      abortCtrlRef.current.abort();
    };
  }, []);
  (0, _react.useEffect)(() => {
    const error = detectionEnginePrivileges.error;
    if (error != null) {
      addError(error, {
        title: i18n.DETECTION_ENGINE_PRIVILEGES_FETCH_FAILURE
      });
    }
  }, [addError, detectionEnginePrivileges.error]);
  return detectionEnginePrivileges;
};
exports.useFetchDetectionEnginePrivileges = useFetchDetectionEnginePrivileges;