"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTermsAggregationFields = exports.getQueryRequiredMessage = void 0;
var _translations = require("./translations");
var _utils = require("../../../../../common/detection_engine/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Filters out fields, that are not supported in terms aggregation.
 * Terms aggregation supports limited number of types:
 * Keyword, Numeric, ip, boolean, or binary.
 * https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-bucket-terms-aggregation.html
 */
const getTermsAggregationFields = fields => {
  // binary types is excluded, as binary field has property aggregatable === false
  const allowedTypesSet = new Set(['string', 'number', 'ip', 'boolean']);
  return fields.filter(field => field.aggregatable === true && allowedTypesSet.has(field.type));
};

/**
 * return query is required message depends on a rule type
 */
exports.getTermsAggregationFields = getTermsAggregationFields;
const getQueryRequiredMessage = ruleType => {
  if ((0, _utils.isEsqlRule)(ruleType)) {
    return _translations.ESQL_QUERY_REQUIRED;
  }
  if ((0, _utils.isEqlRule)(ruleType)) {
    return _translations.EQL_QUERY_REQUIRED;
  }
  return _translations.CUSTOM_QUERY_REQUIRED;
};
exports.getQueryRequiredMessage = getQueryRequiredMessage;